/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.impl.portletAPIImp;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequestDispatcher;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.log.LogUtil;
import org.exoplatform.services.portletcontainer.ExoPortletContext;
import org.exoplatform.services.portletcontainer.impl.PortletContainerConf;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.PortletRequestDispatcherImp;

public class PortletContextImpl
implements PortletContext,
ExoPortletContext {
    private ServletContext servletContext_;
    private Log log = LogUtil.getLog((String)"org.exoplatform.services.portletcontainer");
    protected ExoContainer cont;

    public PortletContextImpl(ExoContainer cont, ServletContext scontext) {
        this.servletContext_ = scontext;
        this.cont = cont;
    }

    public ExoContainer getContainer() {
        return this.cont;
    }

    public String getServerInfo() {
        String si = this.servletContext_.getServerInfo();
        String si2 = "";
        if (si.indexOf("/") < 0) {
            boolean n = false;
            for (int i = 1; i <= si.length(); ++i) {
                char c = si.charAt(i - 1);
                if (c >= '0' && c <= '9' && !n) {
                    si2 = si2 + "/";
                    n = true;
                }
                si2 = si2 + (char)c;
            }
        }
        return si2;
    }

    public PortletRequestDispatcher getRequestDispatcher(String path) {
        if (path == null || !path.startsWith("/")) {
            return null;
        }
        RequestDispatcher rD = null;
        try {
            rD = this.servletContext_.getRequestDispatcher(path);
            if (rD == null) {
                return null;
            }
        }
        catch (IllegalArgumentException e) {
            this.log.error((Object)"Can not lookup request dispatcher", (Throwable)e);
            return null;
        }
        return new PortletRequestDispatcherImp(this.cont, rD, path);
    }

    public PortletRequestDispatcher getNamedDispatcher(String name) {
        RequestDispatcher rD = null;
        try {
            rD = this.servletContext_.getNamedDispatcher(name);
            if (rD == null) {
                return null;
            }
        }
        catch (IllegalArgumentException e) {
            this.log.error((Object)"Can not lookup request dispatcher", (Throwable)e);
            return null;
        }
        return new PortletRequestDispatcherImp(this.cont, rD, name);
    }

    public InputStream getResourceAsStream(String path) {
        return this.servletContext_.getResourceAsStream(path);
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public String getMimeType(String file) {
        return this.servletContext_.getMimeType(file);
    }

    public String getRealPath(String path) {
        return this.servletContext_.getRealPath(path);
    }

    public Set getResourcePaths(String path) {
        return this.servletContext_.getResourcePaths(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        if (!path.startsWith("/")) {
            throw new MalformedURLException("path must start with /");
        }
        return this.servletContext_.getResource(path);
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The attribute name cannot be null");
        }
        return this.servletContext_.getAttribute(name);
    }

    public void removeAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The attribute name cannot be null");
        }
        this.servletContext_.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("The attribute name cannot be null");
        }
        if (value == null) {
            this.servletContext_.removeAttribute(name);
        } else {
            this.servletContext_.setAttribute(name, value);
        }
    }

    public Enumeration getAttributeNames() {
        return this.servletContext_.getAttributeNames();
    }

    public String getInitParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("argument must not be null");
        }
        return this.servletContext_.getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        return this.servletContext_.getInitParameterNames();
    }

    public String getPortletContextName() {
        return this.servletContext_.getServletContextName();
    }

    public ServletContext getWrappedServletContext() {
        return this.servletContext_;
    }

    public boolean isSessionShared() {
        PortletContainerConf conf = (PortletContainerConf)this.cont.getComponentInstanceOfType(PortletContainerConf.class);
        return conf.isSharedSessionEnable();
    }

    public void log(String msg) {
        this.servletContext_.log(msg);
    }

    public void log(String message, Throwable throwable) {
        this.servletContext_.log(message, throwable);
    }
}

