/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.impl.portletAPIImp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortalContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.WindowState;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.log.LogUtil;
import org.exoplatform.services.portletcontainer.ExoPortletRequest;
import org.exoplatform.services.portletcontainer.helper.PortletWindowInternal;
import org.exoplatform.services.portletcontainer.impl.PortletApplicationProxy;
import org.exoplatform.services.portletcontainer.impl.PortletContainerConf;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.PortletSessionImp;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.helpers.SharedSessionWrapper;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.pool.EmptyRequest;
import org.exoplatform.services.portletcontainer.pci.Input;
import org.exoplatform.services.portletcontainer.pci.WindowID;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.pci.model.SecurityConstraint;
import org.exoplatform.services.portletcontainer.pci.model.SecurityRoleRef;
import org.exoplatform.services.portletcontainer.pci.model.Supports;

public class PortletRequestImp
extends HttpServletRequestWrapper
implements PortletRequest,
ExoPortletRequest,
Map {
    private Collection roles_;
    private PortletSessionImp session_;
    private Portlet portletDatas_;
    protected Input input_;
    private PortletWindowInternal portletWindowInternal_;
    private PortalContext portalContext_;
    private PortletContext portletContext_;
    private List securityContraints_;
    private List userAttributes_;
    private List customPortletModes_;
    protected List customWindowStates_;
    private Collection supportedContents_;
    private Log log_ = LogUtil.getLog((String)"org.exoplatform.services.portletcontainer");
    protected ExoContainer cont;

    public PortletRequestImp(ExoContainer cont, HttpServletRequest httpServletRequest) {
        super(httpServletRequest);
        this.cont = cont;
    }

    public void fillPortletRequest(HttpServletRequest httpServletRequest, PortalContext portalContext, PortletContext portletContext, PortletSessionImp session, Portlet portletDatas, Input input, PortletWindowInternal portletWindowInternal, List securityContraints, List userAttributes, List customPortletModes, List customWindowStates, Collection roles, Collection supportedContents) {
        super.setRequest((ServletRequest)httpServletRequest);
        this.portalContext_ = portalContext;
        this.portletContext_ = portletContext;
        this.session_ = session;
        this.portletDatas_ = portletDatas;
        this.input_ = input;
        this.portletWindowInternal_ = portletWindowInternal;
        this.securityContraints_ = securityContraints;
        this.userAttributes_ = userAttributes;
        this.customPortletModes_ = customPortletModes;
        this.customWindowStates_ = customWindowStates;
        this.roles_ = roles;
        this.supportedContents_ = supportedContents;
        this.init();
    }

    public void emptyPortletRequest() {
        super.setRequest((ServletRequest)new EmptyRequest());
    }

    public void init() {
    }

    public Input getInput() {
        return this.input_;
    }

    public boolean isWindowStateAllowed(WindowState windowState) {
        Enumeration e = this.portalContext_.getSupportedWindowStates();
        while (e.hasMoreElements()) {
            WindowState supportedWindowState = (WindowState)e.nextElement();
            if (!supportedWindowState.equals((Object)windowState)) continue;
            return true;
        }
        return false;
    }

    public boolean isPortletModeAllowed(PortletMode portletMode) {
        Enumeration e = this.portalContext_.getSupportedPortletModes();
        while (e.hasMoreElements()) {
            PortletMode supportedPortletMode = (PortletMode)e.nextElement();
            if (!supportedPortletMode.toString().toLowerCase().equals(portletMode.toString().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public PortletConfig getPortletConfig() {
        ExoContainer manager = this.cont;
        String portletAppName = this.portletWindowInternal_.getWindowID().getPortletApplicationName();
        PortletApplicationProxy proxy = (PortletApplicationProxy)manager.getComponentInstance((Object)portletAppName);
        return proxy.getPortletConfig(this.portletWindowInternal_.getWindowID().getPortletName());
    }

    public PortletMode getPortletMode() {
        return this.input_.getPortletMode();
    }

    public WindowState getWindowState() {
        return this.input_.getWindowState();
    }

    public PortletPreferences getPreferences() {
        return this.portletWindowInternal_.getPreferences();
    }

    public PortletSession getPortletSession() {
        return this.getPortletSession(true);
    }

    public PortletSession getPortletSession(boolean create) {
        PortletContainerConf conf = (PortletContainerConf)this.cont.getComponentInstanceOfType(PortletContainerConf.class);
        boolean isSharedSessionEnable = conf.isSharedSessionEnable();
        if (create) {
            if (this.session_.isSessionValid()) {
                return this.session_;
            }
            if (isSharedSessionEnable) {
                ((SharedSessionWrapper)this.session_.getSession()).init();
            } else {
                this.session_.setSession(((HttpServletRequest)super.getRequest()).getSession());
            }
            return this.session_;
        }
        if (isSharedSessionEnable) {
            if (this.session_.isSessionValid()) {
                return this.session_;
            }
        } else {
            HttpSession tmpSession = ((HttpServletRequest)super.getRequest()).getSession(false);
            if (tmpSession == null) {
                return null;
            }
            try {
                tmpSession.getLastAccessedTime();
            }
            catch (IllegalStateException e) {
                this.log_.error((Object)"IllegalStateExcetion sent in PortletRequestImp getPortletSession()", (Throwable)e);
                return null;
            }
            return this.session_;
        }
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        PortletContainerConf conf = (PortletContainerConf)this.cont.getComponentInstanceOfType(PortletContainerConf.class);
        boolean isSharedSessionEnable = conf.isSharedSessionEnable();
        if (isSharedSessionEnable) {
            return this.session_.isSessionValid();
        }
        if (((HttpServletRequest)super.getRequest()).isRequestedSessionIdValid()) {
            try {
                ((HttpServletRequest)super.getRequest()).getSession().getLastAccessedTime();
            }
            catch (IllegalStateException e) {
                this.log_.error((Object)"IllegalStateExcetion sent in PortletRequestImp isRequestedSessionIdValid()", (Throwable)e);
                return false;
            }
        }
        return ((HttpServletRequest)super.getRequest()).isRequestedSessionIdValid();
    }

    public String getProperty(String s) {
        String header = ((HttpServletRequest)super.getRequest()).getHeader(s);
        if (header != null) {
            return header;
        }
        return this.portalContext_.getProperty(s);
    }

    public Enumeration getProperties(String s) {
        Enumeration header = ((HttpServletRequest)super.getRequest()).getHeaders(s);
        return header;
    }

    public Enumeration getPropertyNames() {
        String s;
        Enumeration headerNames = ((HttpServletRequest)super.getRequest()).getHeaderNames();
        Enumeration portalPropertyNames = this.portalContext_.getPropertyNames();
        ArrayList<String> global = new ArrayList<String>();
        while (portalPropertyNames.hasMoreElements()) {
            s = (String)portalPropertyNames.nextElement();
            global.add(s);
        }
        while (headerNames.hasMoreElements()) {
            s = (String)headerNames.nextElement();
            global.add(s);
        }
        return Collections.enumeration(global);
    }

    public PortalContext getPortalContext() {
        return this.portalContext_;
    }

    public String getResponseContentType() {
        List l = this.portletDatas_.getSupports();
        String markup = this.input_.getMarkup();
        String inputPortletMode = this.input_.getPortletMode().toString();
        for (int i = 0; i < l.size(); ++i) {
            Supports supportsType = (Supports)l.get(i);
            String mimeType = supportsType.getMimeType();
            if (!mimeType.equals(markup)) continue;
            List portletModes = supportsType.getPortletMode();
            for (int modeIdx = 0; modeIdx < portletModes.size(); ++modeIdx) {
                String portletMode = (String)portletModes.get(modeIdx);
                if (!portletMode.equals(inputPortletMode)) continue;
                return mimeType;
            }
        }
        return "text/html";
    }

    public Enumeration getResponseContentTypes() {
        ArrayList<String> c = new ArrayList<String>();
        c.add(this.getResponseContentType());
        String markup = this.input_.getMarkup();
        String inputPortletMode = this.input_.getPortletMode().toString();
        for (String supportedContent : this.supportedContents_) {
            List l = this.portletDatas_.getSupports();
            block1: for (int i = 0; i < l.size(); ++i) {
                Supports supportsType = (Supports)l.get(i);
                String mimeType = supportsType.getMimeType();
                if (!supportedContent.equals(mimeType) || supportedContent.equals(markup)) continue;
                List portletModes = supportsType.getPortletMode();
                for (String portletMode : portletModes) {
                    if (!portletMode.equals(inputPortletMode)) continue;
                    c.add(mimeType);
                    continue block1;
                }
            }
        }
        return Collections.enumeration(c);
    }

    public boolean isUserInRole(String role) {
        List l = this.portletDatas_.getSecurityRoleRef();
        for (SecurityRoleRef securityRoleRef : l) {
            if (!securityRoleRef.getRoleName().equals(role)) continue;
            String roleLink = securityRoleRef.getRoleLink();
            if (roleLink == null || "".equals(roleLink)) {
                if (this.isRoleDefinedInWebXML(role)) {
                    return super.isUserInRole(role);
                }
                return false;
            }
            if (this.isRoleDefinedInWebXML(roleLink)) {
                return super.isUserInRole(roleLink);
            }
            return false;
        }
        return false;
    }

    private boolean isRoleDefinedInWebXML(String role) {
        for (String roleDefined : this.roles_) {
            if (!roleDefined.equals(role)) continue;
            return true;
        }
        return false;
    }

    public Portlet getPortletDatas() {
        return this.portletDatas_;
    }

    public PortletWindowInternal getPortletWindowInternal() {
        return this.portletWindowInternal_;
    }

    public boolean needsSecurityContraints(String portletName) {
        for (SecurityConstraint securityConstraint : this.securityContraints_) {
            List l = securityConstraint.getPortletCollection().getPortletName();
            for (String portletN : l) {
                if (!portletN.equals(portletName)) continue;
                return true;
            }
        }
        return false;
    }

    public String getAuthType() {
        String type = super.getAuthType();
        if ("BASIC".equals(type)) {
            return "BASIC";
        }
        if ("DIGEST".equals(type)) {
            return "DIGEST";
        }
        if ("CLIENT_CERT".equals(type)) {
            return "CLIENT_CERT";
        }
        if ("FORM".equals(type)) {
            return "FORM";
        }
        return type;
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The attribute name cannot be null");
        }
        return super.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("The attribute name cannot be null");
        }
        if (value == null) {
            super.removeAttribute(name);
        } else {
            super.setAttribute(name, value);
        }
    }

    public void removeAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The attribute name cannot be null");
        }
        super.removeAttribute(name);
    }

    public String getContextPath() {
        return "/" + this.portletContext_.getPortletContextName();
    }

    public int size() {
        int n = 0;
        Enumeration keys = this.getAttributeNames();
        while (keys.hasMoreElements()) {
            ++n;
        }
        return n;
    }

    public boolean isEmpty() {
        return !this.getAttributeNames().hasMoreElements();
    }

    public boolean containsKey(Object key) {
        return this.getAttribute((String)key) != null;
    }

    public boolean containsValue(Object value) {
        boolean match = false;
        Enumeration keys = this.getAttributeNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object val = this.getAttribute(key);
            if (!value.equals(val)) continue;
            match = true;
            break;
        }
        return match;
    }

    public Object get(Object key) {
        return this.getAttribute((String)key);
    }

    public Object put(Object key, Object value) {
        Object result = null;
        if (this.containsKey(key)) {
            result = this.getAttribute((String)key);
        }
        this.setAttribute((String)key, value);
        return result;
    }

    public Object remove(Object key) {
        Object result = null;
        if (this.containsKey(key)) {
            result = this.getAttribute((String)key);
        }
        this.removeAttribute((String)key);
        return result;
    }

    public void putAll(Map t) {
        for (String key : t.keySet()) {
            Object value = t.get(key);
            this.put(key, value);
        }
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public Locale getLocale() {
        List locales = this.input_.getLocales();
        if (locales != null && !locales.isEmpty()) {
            return (Locale)locales.iterator().next();
        }
        return super.getLocale();
    }

    public Enumeration getLocales() {
        List locales = this.input_.getLocales();
        if (locales != null) {
            return Collections.enumeration(locales);
        }
        return super.getLocales();
    }

    public WindowID getWindowID() {
        return this.input_.getWindowID();
    }
}

