/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.impl.portletAPIImp;

import java.util.Enumeration;
import java.util.Vector;
import javax.portlet.PortletContext;
import javax.portlet.PortletSession;
import javax.portlet.PortletSessionUtil;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.map.AbstractMap;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.log.LogService;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.utils.PortletSessionImpUtil;

public class PortletSessionImp
extends AbstractMap
implements PortletSession {
    private HttpSession session;
    private PortletContext context;
    private String windowId;
    private String applicationId;
    private boolean invalidated;
    private Log log;
    protected ExoContainer cont;

    public PortletSessionImp(ExoContainer cont) {
        this.cont = cont;
        this.log = ((LogService)cont.getComponentInstanceOfType(LogService.class)).getLog("org.exoplatform.services.portletcontainer");
    }

    public void fillPortletSession(HttpSession session, PortletContext context, String windowId) {
        this.session = session;
        this.context = context;
        this.windowId = windowId;
        this.applicationId = context.getPortletContextName();
        this.invalidated = false;
    }

    public void emptyPortletSession() {
        this.windowId = "";
    }

    public Object getAttribute(String name) {
        return this.getAttribute(name, 2);
    }

    public Object getAttribute(String name, int i) {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        if (name == null) {
            throw new IllegalArgumentException("The attribute name cannot be null");
        }
        if (1 == i) {
            return this.session.getAttribute(name);
        }
        if (2 == i) {
            String key = PortletSessionImpUtil.encodePortletSessionAttribute(this.windowId, name, 2);
            return this.session.getAttribute(key);
        }
        return null;
    }

    public void removeAttribute(String name) {
        this.removeAttribute(name, 2);
    }

    public void removeAttribute(String name, int i) {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        if (name == null) {
            throw new IllegalArgumentException("The attribute name cannot be null");
        }
        if (1 == i) {
            this.session.removeAttribute(name);
        } else if (2 == i) {
            String key = PortletSessionImpUtil.encodePortletSessionAttribute(this.windowId, name, 2);
            this.session.removeAttribute(key);
        }
    }

    public final void setAttribute(String name, Object o) {
        this.setAttribute(name, o, 2);
    }

    public void setAttribute(String name, Object o, int i) {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        if (name == null) {
            throw new IllegalArgumentException("The attribute name cannot be null");
        }
        if (1 == i) {
            if (o == null) {
                this.session.removeAttribute(name);
            } else {
                this.session.setAttribute(name, o);
            }
        } else if (2 == i) {
            String key = PortletSessionImpUtil.encodePortletSessionAttribute(this.windowId, name, 2);
            if (o == null) {
                this.session.removeAttribute(key);
            } else {
                this.session.setAttribute(key, o);
            }
        }
    }

    public Enumeration getAttributeNames() {
        return this.getAttributeNames(2);
    }

    public Enumeration getAttributeNames(int i) {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        Enumeration e = this.session.getAttributeNames();
        Vector<String> v = new Vector<String>();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (i == 2) {
                if (PortletSessionUtil.decodeScope((String)s) != 2) continue;
                v.add(PortletSessionUtil.decodeAttributeName((String)s));
                continue;
            }
            if (PortletSessionUtil.decodeScope((String)s) != 1) continue;
            v.add(s);
        }
        return v.elements();
    }

    public long getCreationTime() {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        return this.session.getCreationTime();
    }

    public String getId() {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        return this.session.getId() + this.applicationId;
    }

    public long getLastAccessedTime() {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        return this.session.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        return this.session.getMaxInactiveInterval();
    }

    public void invalidate() {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        this.session.invalidate();
        this.invalidated = true;
    }

    public boolean isSessionValid() {
        try {
            long lastAccessTime = this.session.getLastAccessedTime();
            if (lastAccessTime == 0L) {
                return true;
            }
            if (lastAccessTime == -1L) {
                return false;
            }
            int maxInterval = this.session.getMaxInactiveInterval();
            if (maxInterval < 0) {
                return true;
            }
            if (System.currentTimeMillis() - lastAccessTime > (long)(maxInterval * 1000)) {
                this.session.invalidate();
                return false;
            }
            return true;
        }
        catch (IllegalStateException e) {
            this.log.error((Object)"IllegalStateException in PortletSessionImp for isSessionValid()", (Throwable)e);
            return false;
        }
    }

    public boolean isNew() {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        return this.session.isNew();
    }

    public void setMaxInactiveInterval(int i) {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        this.session.setMaxInactiveInterval(i);
    }

    public PortletContext getPortletContext() {
        return this.context;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public void setSession(HttpSession session) {
        this.session = session;
    }
}

