/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.impl.portletAPIImp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.PortletResponseImp;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.PortletURLImp;
import org.exoplatform.services.portletcontainer.pci.Input;
import org.exoplatform.services.portletcontainer.pci.RenderOutput;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.pci.model.Supports;

public class RenderResponseImp
extends PortletResponseImp
implements RenderResponse {
    private Enumeration supportedWindowState_;
    private Collection supportedContents_;
    private String windowId_;
    private Input input_;
    private Portlet portletDatas_;
    private boolean isCurrentlySecured_;
    private String contentType_;
    private boolean writerAlreadyCalled_;
    private boolean outputStreamAlreadyCalled_;

    public RenderResponseImp(ExoContainer cont, HttpServletResponse httpServletResponse) {
        super(cont, httpServletResponse);
    }

    public void fillRenderResponse(String windowId, Input input, Portlet portletDatas, boolean isCurrentlySecured, Collection supportedContents, Enumeration supportedWindowState) {
        this.windowId_ = windowId;
        this.input_ = input;
        this.portletDatas_ = portletDatas;
        this.isCurrentlySecured_ = isCurrentlySecured;
        this.supportedContents_ = supportedContents;
        this.supportedWindowState_ = supportedWindowState;
        this.writerAlreadyCalled_ = false;
        this.outputStreamAlreadyCalled_ = false;
    }

    public void emptyRenderResponse() {
        this.windowId_ = null;
        this.contentType_ = null;
        this.writerAlreadyCalled_ = false;
        this.outputStreamAlreadyCalled_ = false;
    }

    public String getContentType() {
        if (this.contentType_ == null || "".equals(this.contentType_)) {
            return null;
        }
        return this.contentType_;
    }

    public void setContentType(String contentType) {
        if (contentType != null) {
            contentType = StringUtils.split((String)contentType, (char)';')[0];
        }
        if (!this.isContentTypeSupported(contentType)) {
            throw new IllegalArgumentException("the content type : " + contentType + " is not supported.");
        }
        this.contentType_ = contentType;
    }

    public PortletURL createRenderURL() {
        if (this.input_.getPortletURLFactory() != null) {
            return this.input_.getPortletURLFactory().createPortletURL("render");
        }
        return new PortletURLImp("render", this.input_.getMarkup(), this.portletDatas_.getSupports(), this.isCurrentlySecured_, this.customWindowStates, this.supportedWindowState_, this.input_.getBaseURL(), this.input_.getWindowID());
    }

    public PortletURL createActionURL() {
        if (this.input_.getPortletURLFactory() != null) {
            return this.input_.getPortletURLFactory().createPortletURL("action");
        }
        return new PortletURLImp("action", this.input_.getMarkup(), this.portletDatas_.getSupports(), this.isCurrentlySecured_, this.customWindowStates, this.supportedWindowState_, this.input_.getBaseURL(), this.input_.getWindowID());
    }

    public String getNamespace() {
        return (this.windowId_.replace('-', 'I') + "I").replace('/', 'I');
    }

    public void setTitle(String s) {
        ((RenderOutput)super.getOutput()).setTitle(s);
    }

    public OutputStream getPortletOutputStream() throws IOException {
        if (this.writerAlreadyCalled_) {
            throw new IllegalStateException("getWriter() has already been called");
        }
        if (this.contentType_ == null || "".equals(this.contentType_)) {
            throw new IllegalStateException("the content type has not been set before calling thegetPortletOutputStream() method.");
        }
        this.outputStreamAlreadyCalled_ = true;
        return super.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        if (this.outputStreamAlreadyCalled_) {
            throw new IllegalStateException("the getPortletOutputStream object has already been called");
        }
        if (this.contentType_ == null || "".equals(this.contentType_)) {
            throw new IllegalStateException("the content type has not been set before calling thegetWriter() method.");
        }
        this.writerAlreadyCalled_ = true;
        return super.getWriter();
    }

    private boolean isContentTypeSupported(String contentTypeToTest) {
        Collection c = this.getResponseContentTypes();
        for (String element : c) {
            if (!element.equals(contentTypeToTest)) continue;
            return true;
        }
        return false;
    }

    private Collection getResponseContentTypes() {
        ArrayList<String> c = new ArrayList<String>();
        c.add(this.getResponseContentType());
        for (String element : this.supportedContents_) {
            List l = this.portletDatas_.getSupports();
            block1: for (int i = 0; i < l.size(); ++i) {
                Supports supportsType = (Supports)l.get(i);
                String mimeType = supportsType.getMimeType();
                if (!element.equals(mimeType) || element.equals(this.input_.getMarkup())) continue;
                List portletModes = supportsType.getPortletMode();
                for (String portletMode : portletModes) {
                    if (!portletMode.equals(this.input_.getPortletMode().toString())) continue;
                    c.add(mimeType);
                    continue block1;
                }
            }
        }
        return c;
    }

    private String getResponseContentType() {
        List l = this.portletDatas_.getSupports();
        for (int i = 0; i < l.size(); ++i) {
            Supports supportsType = (Supports)l.get(i);
            String mimeType = supportsType.getMimeType();
            if (!mimeType.equals(this.input_.getMarkup())) continue;
            List portletModes = supportsType.getPortletMode();
            for (String portletMode : portletModes) {
                if (!portletMode.equals(this.input_.getPortletMode().toString())) continue;
                return mimeType;
            }
        }
        return "text/html";
    }

    public void flushBuffer() throws IOException {
    }

    public int getBufferSize() {
        return 0;
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
    }

    public void resetBuffer() {
    }

    public void setBufferSize(int arg0) {
    }

    public Locale getLocale() {
        Locale l = super.getLocale();
        if (l == null) {
            return new Locale("en");
        }
        return l;
    }
}

