/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.impl.portletAPIImp.bundle;

import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.MapResourceBundle;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.LogService;
import org.exoplatform.services.portletcontainer.bundle.ResourceBundleDelegate;
import org.exoplatform.services.portletcontainer.impl.PortletContainerConf;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.pci.model.PortletInfo;

public class ResourceBundleManager {
    public static final String PORTLET_TITLE = "javax.portlet.title";
    public static final String PORTLET_SHORT_TITLE = "javax.portlet.short-title";
    public static final String KEYWORDS = "javax.portlet.keywords";
    private PortletContainerConf conf;
    private ExoCache cache;
    private Log log_;
    protected ExoContainer cont;

    public ResourceBundleManager(PortletContainerConf conf, LogService logService, CacheService cacheService, ExoContainerContext context) throws Exception {
        this.conf = conf;
        this.cache = cacheService.getCacheInstance(this.getClass().getName());
        this.log_ = logService.getLog("org.exoplatform.services.portletcontainer");
        this.cont = context.getContainer();
    }

    public ResourceBundle lookupBundle(Portlet portlet, Locale locale) {
        String bundleName = portlet.getResourceBundle();
        String key = portlet.getPortletClass() + bundleName + locale;
        MapResourceBundle bundle = null;
        try {
            ResourceBundle res = (ResourceBundle)this.cache.get((Serializable)((Object)key));
            if (res != null) {
                return res;
            }
            PortletInfo pI = portlet.getPortletInfo();
            if (bundleName == null || bundleName.equals("")) {
                MapResourceBundle bundle2 = new MapResourceBundle(locale);
                this.initBundle(pI, bundle2);
                this.cache.put((Serializable)((Object)key), (Object)bundle2);
                return bundle2;
            }
            if (locale == null) {
                locale = new Locale("en");
            }
            if (this.conf.isBundleLookupDelegated()) {
                ResourceBundleDelegate delegate = (ResourceBundleDelegate)this.cont.getComponentInstanceOfType(ResourceBundleDelegate.class);
                bundle = (MapResourceBundle)delegate.lookupBundle(bundleName, locale);
                this.initBundle(pI, bundle);
            } else {
                ResourceBundle rB = ResourceBundle.getBundle(bundleName, locale, Thread.currentThread().getContextClassLoader());
                bundle = new MapResourceBundle(rB, locale);
                this.initBundle(pI, bundle);
                this.cache.put((Serializable)((Object)key), (Object)bundle);
            }
        }
        catch (Exception e) {
            this.log_.error((Object)"Can not load resource bundle", (Throwable)e);
        }
        return bundle;
    }

    private void initBundle(PortletInfo pI, MapResourceBundle rB) {
        if (pI != null && pI.getTitle() != null) {
            try {
                rB.getString(PORTLET_TITLE);
            }
            catch (MissingResourceException ex) {
                rB.add(PORTLET_TITLE, (Object)pI.getTitle());
            }
        }
        if (pI != null && pI.getShortTitle() != null) {
            try {
                rB.getString(PORTLET_SHORT_TITLE);
            }
            catch (MissingResourceException ex) {
                rB.add(PORTLET_SHORT_TITLE, (Object)pI.getShortTitle());
            }
        }
        if (pI != null && pI.getKeywords() != null) {
            try {
                rB.getString(KEYWORDS);
            }
            catch (MissingResourceException ex) {
                rB.add(KEYWORDS, (Object)pI.getKeywords());
            }
        }
    }
}

