/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.impl.portletAPIImp.helpers;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.services.portletcontainer.helper.URLEncoder;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.helpers.NestedResponseWrapper;

public class CustomResponseWrapper
extends HttpServletResponseWrapper {
    private String contentType;
    private PrintWriter tmpWriter;
    private ByteArrayOutputStream output;
    private ByteArrayServletOutputStream servletOutput;
    private URLEncoder urlEncoder_;
    private CharArrayWriter charArrayWriter;
    private boolean writerAlreadyCalled;
    private boolean outputStreamAlreadyCalled;
    private static Log log = LogFactory.getLog(CustomResponseWrapper.class);

    public CustomResponseWrapper(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
    }

    public void fillResponseWrapper(HttpServletResponse httpServletResponse) {
        super.setResponse((ServletResponse)httpServletResponse);
        this.output = new ByteArrayOutputStream();
        this.servletOutput = new ByteArrayServletOutputStream(this.output);
        this.charArrayWriter = new CharArrayWriter();
        this.tmpWriter = new PrintWriter(this.charArrayWriter){

            public boolean equals(Object obj) {
                return true;
            }

            public void close() {
                log.debug((Object)"try to close");
            }
        };
        this.writerAlreadyCalled = false;
        this.outputStreamAlreadyCalled = false;
        this.contentType = "";
    }

    public void emptyResponseWrapper() {
        this.output = null;
        this.tmpWriter = null;
        this.servletOutput = null;
        this.writerAlreadyCalled = false;
        this.outputStreamAlreadyCalled = false;
        this.contentType = "";
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String type) {
        super.setContentType(type);
        this.contentType = type;
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.servletOutput.close();
        this.output.close();
        this.tmpWriter.close();
    }

    public char[] getPortletContent() {
        if (this.outputStreamAlreadyCalled) {
            try {
                return new String(this.output.toByteArray(), "utf-8").toCharArray();
            }
            catch (UnsupportedEncodingException e) {
                return new String(this.output.toByteArray()).toCharArray();
            }
        }
        if (this.writerAlreadyCalled) {
            return this.charArrayWriter.toCharArray();
        }
        return null;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.outputStreamAlreadyCalled) {
            throw new IllegalStateException("the output streamobject has already been called");
        }
        this.writerAlreadyCalled = true;
        log.debug((Object)"getWriter()");
        return this.tmpWriter;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writerAlreadyCalled) {
            throw new IllegalStateException("the PrintWriter  has already been called");
        }
        log.debug((Object)"getOutputStream()");
        this.outputStreamAlreadyCalled = true;
        return this.servletOutput;
    }

    public byte[] toByteArray() {
        return this.output.toByteArray();
    }

    public void flushBuffer() throws IOException {
        log.debug((Object)"flushBuffer()");
        this.tmpWriter.flush();
        this.servletOutput.flush();
    }

    public void reset() {
        log.debug((Object)"reset()");
        this.charArrayWriter.reset();
        this.output.reset();
    }

    public void close() throws IOException {
        log.debug((Object)"close()");
    }

    public int getBufferSize() {
        log.debug((Object)"getBufferSize()");
        return 0;
    }

    public String encodeURL(String url) {
        if (this.urlEncoder_ == null) {
            return super.encodeURL(url);
        }
        return this.urlEncoder_.encodeURL(url);
    }

    public void setURLEncoder(URLEncoder encoder) {
        this.urlEncoder_ = encoder;
    }

    public void sendRedirect(String location) throws IOException {
        log.debug((Object)("Send redirect [" + location + "]"));
        super.sendRedirect(location);
    }

    public boolean isStreamUsed() {
        return this.outputStreamAlreadyCalled;
    }

    public boolean equals(Object obj) {
        System.out.println(" --- CustomResponseWrapper.equals: this: " + (Object)((Object)this));
        System.out.println(" --- CustomResponseWrapper.equals:  obj: " + obj);
        if (obj instanceof NestedResponseWrapper) {
            System.out.println(" --- CustomResponseWrapper.equals: obj2: " + ((NestedResponseWrapper)((Object)obj)).getResponse());
            return super.equals(((NestedResponseWrapper)((Object)obj)).getResponse());
        }
        return super.equals(obj);
    }

    private static class ByteArrayServletOutputStream
    extends ServletOutputStream {
        ByteArrayOutputStream baos;

        public ByteArrayServletOutputStream(ByteArrayOutputStream baos) {
            this.baos = baos;
        }

        public void write(int i) throws IOException {
            this.baos.write(i);
        }
    }
}

