/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.impl.portletAPIImp.helpers;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.services.portletcontainer.helper.URLEncoder;
import org.exoplatform.services.portletcontainer.impl.portletAPIImp.helpers.CustomResponseWrapper;

public class NestedResponseWrapper
extends HttpServletResponseWrapper {
    private String contentType;
    private PrintWriter tmpWriter;
    private ProxyServletOutputStream output;
    private URLEncoder urlEncoder_;
    private CharArrayWriter charArrayWriter;
    private boolean writerAlreadyCalled;
    private boolean outputStreamAlreadyCalled;
    private static Log log = LogFactory.getLog(CustomResponseWrapper.class);

    public NestedResponseWrapper(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
    }

    public void fillResponseWrapper(HttpServletResponse httpServletResponse) {
        super.setResponse((ServletResponse)httpServletResponse);
        this.charArrayWriter = new CharArrayWriter();
        this.tmpWriter = new PrintWriter(this.charArrayWriter){

            public boolean equals(Object obj) {
                return true;
            }

            public void close() {
                log.debug((Object)"try to close");
            }
        };
        this.output = new ProxyServletOutputStream(this.tmpWriter);
        this.writerAlreadyCalled = false;
        this.outputStreamAlreadyCalled = false;
        this.contentType = "";
    }

    public void emptyResponseWrapper() {
        this.output = null;
        this.tmpWriter = null;
        this.writerAlreadyCalled = false;
        this.outputStreamAlreadyCalled = false;
        this.contentType = "";
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String type) {
        super.setContentType(type);
        this.contentType = type;
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.output.close();
        this.tmpWriter.close();
    }

    public char[] getPortletContent() {
        if (this.outputStreamAlreadyCalled || this.writerAlreadyCalled) {
            return this.charArrayWriter.toCharArray();
        }
        return null;
    }

    public PrintWriter getWriter() throws IOException {
        this.writerAlreadyCalled = true;
        log.debug((Object)"getWriter()");
        return this.tmpWriter;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        log.debug((Object)"getOutputStream()");
        this.outputStreamAlreadyCalled = true;
        return this.output;
    }

    public byte[] toByteArray() {
        try {
            return new String(this.charArrayWriter.toCharArray()).getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.charArrayWriter.toCharArray()).getBytes();
        }
    }

    public void flushBuffer() throws IOException {
        log.debug((Object)"flushBuffer()");
        this.tmpWriter.flush();
    }

    public void reset() {
        log.debug((Object)"reset()");
        this.charArrayWriter.reset();
    }

    public void close() throws IOException {
        log.debug((Object)"close()");
    }

    public int getBufferSize() {
        log.debug((Object)"getBufferSize()");
        return 0;
    }

    public String encodeURL(String url) {
        if (this.urlEncoder_ == null) {
            return super.encodeURL(url);
        }
        return this.urlEncoder_.encodeURL(url);
    }

    public void setURLEncoder(URLEncoder encoder) {
        this.urlEncoder_ = encoder;
    }

    public void sendRedirect(String location) throws IOException {
        log.debug((Object)("Send redirect [" + location + "]"));
        super.sendRedirect(location);
    }

    public boolean equals(Object obj) {
        System.out.println(" --- NestedResponseWrapper.equals: this: " + (Object)((Object)this));
        System.out.println(" --- NestedResponseWrapper.equals:  obj: " + obj);
        System.out.println(" --- NestedResponseWrapper.equals: obj2: " + this.getResponse());
        return super.equals(obj) || this.getResponse().equals(obj);
    }

    public String encodeRedirectURL(String url) {
        if (url != null) {
            return super.encodeRedirectURL(url);
        }
        return null;
    }

    public String encodeRedirectUrl(String url) {
        if (url != null) {
            return super.encodeRedirectUrl(url);
        }
        return null;
    }

    private static class ProxyServletOutputStream
    extends ServletOutputStream {
        private PrintWriter writer;

        public ProxyServletOutputStream(PrintWriter writer) {
            this.writer = writer;
        }

        public void write(int i) throws IOException {
            this.writer.write(i);
        }
    }
}

