/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.impl.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.LogService;
import org.exoplatform.services.portletcontainer.PortletContainerException;
import org.exoplatform.services.portletcontainer.helper.PortletWindowInternal;
import org.exoplatform.services.portletcontainer.impl.PortletApplicationHandler;
import org.exoplatform.services.portletcontainer.impl.PortletContainerDispatcher;
import org.exoplatform.services.portletcontainer.pci.Input;
import org.exoplatform.services.portletcontainer.pci.Output;

public class ServletWrapper
extends HttpServlet {
    HashMap session_data = new HashMap();

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    protected void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        ExoContainer manager = ExoContainerContext.getContainerByName((String)((String)servletRequest.getAttribute("org.exoplatform.container.ExoContainer")));
        LogService logService = (LogService)manager.getComponentInstanceOfType(LogService.class);
        PortletApplicationHandler handler = (PortletApplicationHandler)manager.getComponentInstanceOfType(PortletApplicationHandler.class);
        Log log = logService.getLog("org.exoplatform.services.portletcontainer");
        log.debug((Object)"Service method of ServletWrapper entered");
        log.debug((Object)("Encoding used : " + servletRequest.getCharacterEncoding()));
        if (servletRequest.getAttribute("org.exoplatform.services.portletcontainer.pci.ATTRS") != null) {
            HttpSession ss = servletRequest.getSession();
            HashMap attrs = (HashMap)servletRequest.getAttribute("org.exoplatform.services.portletcontainer.pci.ATTRS");
            for (String an : attrs.keySet()) {
                ss.setAttribute(an, attrs.get(an));
                System.out.println("Received status for : " + an + " = " + attrs.get(an));
            }
            return;
        }
        boolean isToGetBundle = false;
        Boolean b = (Boolean)servletRequest.getAttribute("org.exoplatform.services.portletcontainer.impl.isToGetBundle");
        if (b != null) {
            isToGetBundle = b;
        }
        if (isToGetBundle) {
            log.debug((Object)"Get bundle");
            String portletAppName = (String)servletRequest.getAttribute(PortletContainerDispatcher.PORTLET_APPLICATION_NAME);
            String portletName = (String)servletRequest.getAttribute(PortletContainerDispatcher.PORTLET_NAME);
            ResourceBundle bundle = handler.getBundle(portletAppName, portletName, (Locale)servletRequest.getAttribute("org.exoplatform.services.portletcontainer.impl.LocaleForBundle"));
            servletRequest.setAttribute("org.exoplatform.services.portletcontainer.impl.Bundle", (Object)bundle);
            return;
        }
        PortletWindowInternal windowInfo = (PortletWindowInternal)servletRequest.getAttribute("org.exoplatform.services.portletcontainer.impl.portletAPIImp.helpers.PortletWindowInternal");
        Input input = (Input)servletRequest.getAttribute("org.exoplatform.services.portletcontainer.pci.Input");
        Output output = (Output)servletRequest.getAttribute("org.exoplatform.services.portletcontainer.pci.Output");
        boolean isAction = (Boolean)servletRequest.getAttribute("org.exoplatform.services.portletcontainer.impl.isAction");
        try {
            handler.process(this.getServletContext(), servletRequest, servletResponse, input, output, windowInfo, isAction);
        }
        catch (PortletContainerException e) {
            log.error((Object)"An error occured while processing the portlet request", (Throwable)e);
            throw new ServletException("An error occured while processing the portlet request", (Throwable)e);
        }
        try {
            Enumeration en = servletRequest.getSession().getAttributeNames();
            while (en.hasMoreElements()) {
                String attrname = (String)en.nextElement();
                Object obj = servletRequest.getSession().getAttribute(attrname);
                this.session_data.put(attrname, obj);
                output.setSessionMap(this.session_data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

