/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.SessionContainerInitializer;
import org.exoplatform.container.SimpleComponentAdapterFactory;
import org.exoplatform.container.monitor.SessionMonitor;
import org.exoplatform.container.monitor.SessionMonitorListenerStack;
import org.picocontainer.PicoContainer;

public class SessionContainer
extends ExoContainer {
    private static ThreadLocal threadLocal_ = new ThreadLocal();
    private String portalName_;
    private SessionMonitor monitor_;
    private String id_;

    public SessionContainer(PortalContainer parent, String id, String owner) {
        super(new SimpleComponentAdapterFactory(), (PicoContainer)parent);
        this.id_ = id;
        SessionMonitorListenerStack stack = (SessionMonitorListenerStack)((Object)parent.getComponentInstanceOfType(SessionMonitorListenerStack.class));
        this.monitor_ = new SessionMonitor(stack, owner);
        this.registerComponentInstance(this.monitor_);
        List factories = parent.getComponentInstancesOfType(SessionContainerInitializer.class);
        for (int i = 0; i < factories.size(); ++i) {
            SessionContainerInitializer initializer = (SessionContainerInitializer)factories.get(i);
            initializer.initialize(this);
        }
    }

    public String getId() {
        return this.id_;
    }

    public String getOwner() {
        return this.monitor_.getSessionOwner();
    }

    public SessionMonitor getMonitor() {
        return this.monitor_;
    }

    public String getPortalName() {
        return this.portalName_;
    }

    public void setPortalName(String name) {
        this.portalName_ = name;
    }

    public static SessionContainer getInstance() {
        return (SessionContainer)((Object)threadLocal_.get());
    }

    public static void setInstance(SessionContainer scontainer) {
        threadLocal_.set(scontainer);
    }

    public void startActionLifcycle() {
        threadLocal_.set(this);
    }

    public void endActionLifcycle() {
        threadLocal_.set(null);
    }

    public void stop() {
        if (this.monitor_ == null) {
            return;
        }
        this.monitor_.getListeners().onStop(this.monitor_);
        this.monitor_ = null;
        super.stop();
    }

    public static Object getComponent(Class key) {
        SessionContainer scontainer = (SessionContainer)((Object)threadLocal_.get());
        return scontainer.getComponentInstanceOfType(key);
    }
}

