/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.output;

import gg.jte.TemplateOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public final class Utf8ByteOutput
implements TemplateOutput {
    private final List<byte[]> chunks;
    private int contentLength;

    public Utf8ByteOutput() {
        this(512);
    }

    public Utf8ByteOutput(int initialCapacity) {
        this.chunks = new ArrayList<byte[]>(initialCapacity);
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void writeTo(OutputStream os) throws IOException {
        this.writeTo(os::write);
    }

    public void writeTo(DataConsumer dataConsumer) throws IOException {
        for (byte[] chunk : this.chunks) {
            dataConsumer.accept(chunk, 0, chunk.length);
        }
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this.contentLength];
        int index = 0;
        for (byte[] chunk : this.chunks) {
            System.arraycopy(chunk, 0, result, index, chunk.length);
            index += chunk.length;
        }
        return result;
    }

    @Override
    public void writeContent(String s) {
        this.addChunk(s.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void writeContent(String s, int beginIndex, int endIndex) {
        this.addChunk(s.substring(beginIndex, endIndex).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void writeBinaryContent(byte[] value) {
        this.addChunk(value);
    }

    private void addChunk(byte[] chunk) {
        this.chunks.add(chunk);
        this.contentLength += chunk.length;
    }

    @FunctionalInterface
    public static interface DataConsumer {
        public void accept(byte[] var1, int var2, int var3) throws IOException;
    }
}

