/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import java.lang.reflect.Constructor;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;

public class ConstructorCallExpression
extends Expression {
    private Expression arguments;
    private Constructor constructor = null;

    public Constructor getConstructor() {
        return this.constructor;
    }

    public ConstructorCallExpression(ClassNode type, Expression arguments) {
        super.setType(type);
        this.arguments = arguments;
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitConstructorCallExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        return new ConstructorCallExpression(this.getType(), transformer.transform(this.arguments));
    }

    public Expression getArguments() {
        return this.arguments;
    }

    public String getText() {
        return "new " + this.getType() + "(" + this.arguments.getText() + ")";
    }

    public String toString() {
        return super.toString() + "[type: " + this.getType() + " arguments: " + this.arguments + "]";
    }

    public void setConstructor(Constructor ctor) {
        this.constructor = ctor;
        super.setType(ClassHelper.make(ctor.getDeclaringClass()));
    }
}

