/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8RuntimeException;
import guru.nidi.graphviz.engine.AbstractGraphvizEngine;
import guru.nidi.graphviz.engine.AbstractJsGraphvizEngine;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.engine.ResultHandler;
import java.io.IOException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphvizV8Engine
extends AbstractJsGraphvizEngine {
    private static final ThreadLocal<Env> ENVS = new ThreadLocal();
    @Nullable
    private final String extractionPath;

    public GraphvizV8Engine() {
        this(null);
    }

    public GraphvizV8Engine(@Nullable String extractionPath) {
        super(true);
        this.extractionPath = extractionPath;
    }

    @Override
    public void close() {
        GraphvizV8Engine.releaseThread();
    }

    static void releaseThread() {
        Env env = ENVS.get();
        if (env != null) {
            env.close();
            ENVS.remove();
        }
    }

    @Override
    protected void doInit() throws IOException {
        ENVS.set(new Env(this.extractionPath, this.jsInitEnv(), this.jsVizCode()));
    }

    @Override
    protected String jsExecute(String call) {
        Env env = ENVS.get();
        if (env == null) {
            try {
                this.doInit();
            }
            catch (IOException e) {
                throw new GraphvizException("Could not initialize v8 engine for new thread", e);
            }
        }
        return ENVS.get().execute(call);
    }

    private static class Env
    implements AutoCloseable {
        private static final Logger LOG = LoggerFactory.getLogger(AbstractGraphvizEngine.class);
        final V8 v8;
        final ResultHandler resultHandler = new ResultHandler();

        Env(@Nullable String extractionPath, String init, String viz) {
            LOG.info("Starting V8 runtime...");
            this.v8 = V8.createV8Runtime(null, (String)extractionPath);
            LOG.info("Started V8 runtime. Initializing graphviz...");
            this.v8.executeVoidScript(viz);
            this.v8.executeVoidScript(init);
            this.v8.registerJavaMethod((receiver, parameters) -> this.resultHandler.setResult(parameters.getString(0)), "result");
            this.v8.registerJavaMethod((receiver, parameters) -> this.resultHandler.setError(parameters.getString(0)), "error");
            LOG.info("Initialized graphviz.");
        }

        String execute(String call) {
            try {
                this.v8.executeVoidScript(call);
                return this.resultHandler.waitFor();
            }
            catch (V8RuntimeException e) {
                throw new GraphvizException("Problem executing graphviz", e);
            }
        }

        @Override
        public void close() {
            this.v8.release(true);
        }
    }
}

