/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.Engine;
import guru.nidi.graphviz.engine.Format;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class Options {
    private static final Pattern FORMAT = Pattern.compile("format:'(.*?)'");
    private static final Pattern ENGINE = Pattern.compile("engine:'(.*?)'");
    private static final Pattern MEMORY = Pattern.compile("totalMemory:'(.*?)'");
    private static final Pattern Y_INVERT = Pattern.compile("yInvert:(.*?)");
    final Engine engine;
    final Format format;
    @Nullable
    final Integer totalMemory;
    @Nullable
    final Boolean yInvert;

    private Options(Engine engine, Format format, @Nullable Integer totalMemory, @Nullable Boolean yInvert) {
        this.engine = engine;
        this.format = format;
        this.totalMemory = totalMemory;
        this.yInvert = yInvert;
    }

    public static Options create() {
        return new Options(Engine.DOT, Format.SVG, null, null);
    }

    public static Options fromJson(String json) {
        Matcher format = FORMAT.matcher(json);
        format.find();
        Matcher engine = ENGINE.matcher(json);
        engine.find();
        Matcher memory = MEMORY.matcher(json);
        boolean hasMemory = memory.find();
        Matcher yInvert = Y_INVERT.matcher(json);
        boolean hasYInvert = yInvert.find();
        return new Options(Engine.valueOf(engine.group(1)), Format.valueOf(format.group(1)), hasMemory ? Integer.valueOf(Integer.parseInt(memory.group(1))) : null, hasYInvert ? Boolean.valueOf(Boolean.parseBoolean(yInvert.group(1))) : null);
    }

    public Options engine(Engine engine) {
        return new Options(engine, this.format, this.totalMemory, this.yInvert);
    }

    public Options format(Format format) {
        return new Options(this.engine, format, this.totalMemory, this.yInvert);
    }

    public Options totalMemory(@Nullable Integer totalMemory) {
        return new Options(this.engine, this.format, totalMemory, this.yInvert);
    }

    public Options yInvert(@Nullable Boolean yInvert) {
        return new Options(this.engine, this.format, this.totalMemory, yInvert);
    }

    public Options fontAdjust(double fontAdjust) {
        return new Options(this.engine, this.format, this.totalMemory, this.yInvert);
    }

    public String toJson(boolean raw) {
        String form = "format:'" + (raw ? this.format : this.format.vizName) + "'";
        String eng = ",engine:'" + (raw ? this.engine : this.engine.toString().toLowerCase(Locale.ENGLISH)) + "'";
        String mem = this.totalMemory == null ? "" : ",totalMemory:'" + this.totalMemory + "'";
        String yInv = this.yInvert == null ? "" : ",yInvert:" + this.yInvert;
        return "{" + form + eng + mem + yInv + "}";
    }
}

