/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.SimpleLabel;
import guru.nidi.graphviz.model.Compass;
import guru.nidi.graphviz.model.ImmutablePortNode;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableAttributed;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Serializer {
    private final MutableGraph graph;
    private final StringBuilder str;

    public Serializer(MutableGraph graph) {
        this.graph = graph;
        this.str = new StringBuilder();
    }

    public String serialize() {
        this.graph(this.graph, true);
        return this.str.toString();
    }

    private void graph(MutableGraph graph, boolean toplevel) {
        this.graphInit(graph, toplevel);
        this.graphAttrs(graph);
        ArrayList<MutableNode> nodes = new ArrayList<MutableNode>();
        ArrayList<MutableGraph> graphs = new ArrayList<MutableGraph>();
        Collection<LinkSource> linkSources = this.linkedNodes(graph.nodes);
        linkSources.addAll(this.linkedNodes(graph.subgraphs));
        for (LinkSource linkSource : linkSources) {
            if (linkSource instanceof MutableNode) {
                MutableNode node = (MutableNode)linkSource;
                int i = this.indexOfName(nodes, node.name);
                if (i < 0) {
                    nodes.add(node);
                    continue;
                }
                nodes.set(i, node.copy().merge((MutableNode)nodes.get(i)));
                continue;
            }
            graphs.add((MutableGraph)linkSource);
        }
        this.nodes(graph, nodes);
        this.graphs(graphs, nodes);
        this.edges(nodes);
        this.edges(graphs);
        this.str.append('}');
    }

    private void graphAttrs(MutableGraph graph) {
        this.attributes("graph", graph.graphAttrs);
        this.attributes("node", graph.nodeAttrs);
        this.attributes("edge", graph.linkAttrs);
    }

    private void graphInit(MutableGraph graph, boolean toplevel) {
        if (toplevel) {
            this.str.append(graph.strict ? "strict " : "").append(graph.directed ? "digraph " : "graph ");
            if (!graph.name.isEmpty()) {
                this.str.append(SimpleLabel.of(graph.name).serialized()).append(' ');
            }
        } else if (!graph.name.isEmpty() || graph.cluster) {
            this.str.append("subgraph ").append(Label.of((graph.cluster ? "cluster_" : "") + graph.name).serialized()).append(' ');
        }
        this.str.append("{\n");
    }

    private int indexOfName(List<MutableNode> nodes, Label name) {
        for (int i = 0; i < nodes.size(); ++i) {
            if (!nodes.get((int)i).name.equals(name)) continue;
            return i;
        }
        return -1;
    }

    private void attributes(String name, MutableAttributed<?, ?> attributed) {
        if (!attributed.isEmpty()) {
            this.str.append(name);
            this.attrs(attributed);
            this.str.append('\n');
        }
    }

    private Collection<LinkSource> linkedNodes(Collection<? extends LinkSource> nodes) {
        LinkedHashSet<LinkSource> visited = new LinkedHashSet<LinkSource>();
        for (LinkSource linkSource : nodes) {
            this.linkedNodes(linkSource, visited);
        }
        return visited;
    }

    private void linkedNodes(LinkSource linkSource, Set<LinkSource> visited) {
        if (!visited.contains(linkSource)) {
            visited.add(linkSource);
            for (Link link : linkSource.links()) {
                this.linkedNodes(link.to.asLinkSource(), visited);
            }
        }
    }

    private void nodes(MutableGraph graph, List<MutableNode> nodes) {
        for (MutableNode node : nodes) {
            if (node.attributes.isEmpty() && (!graph.nodes.contains(node) || !node.links.isEmpty() || this.isLinked(node, nodes))) continue;
            this.node(node);
            this.str.append('\n');
        }
    }

    private void node(MutableNode node) {
        this.str.append(node.name.serialized());
        this.attrs(node.attributes);
    }

    private boolean isLinked(MutableNode node, List<MutableNode> nodes) {
        for (MutableNode m : nodes) {
            for (Link link : m.links) {
                if (!this.isNode(link.to, node)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isLinked(MutableGraph graph, List<? extends LinkSource> linkSources) {
        for (LinkSource linkSource : linkSources) {
            for (Link link : linkSource.links()) {
                if (!link.to.equals(graph)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNode(LinkTarget target, MutableNode node) {
        return target == node || target instanceof ImmutablePortNode && ((ImmutablePortNode)target).node() == node;
    }

    private void graphs(List<MutableGraph> graphs, List<MutableNode> nodes) {
        for (MutableGraph graph : graphs) {
            if (!graph.links.isEmpty() || this.isLinked(graph, nodes) || this.isLinked(graph, graphs)) continue;
            this.graph(graph, false);
            this.str.append('\n');
        }
    }

    private void edges(List<? extends LinkSource> linkSources) {
        for (LinkSource linkSource : linkSources) {
            for (Link link : linkSource.links()) {
                this.linkTarget(link.from);
                this.str.append(this.graph.directed ? " -> " : " -- ");
                this.linkTarget(link.to);
                this.attrs(link.attributes);
                this.str.append('\n');
            }
        }
    }

    private void linkTarget(Object linkable) {
        if (linkable instanceof MutableNode) {
            this.str.append(((MutableNode)linkable).name.serialized());
        } else if (linkable instanceof ImmutablePortNode) {
            this.port((ImmutablePortNode)linkable);
        } else if (linkable instanceof MutableGraph) {
            this.graph((MutableGraph)linkable, false);
        } else {
            throw new IllegalStateException("unexpected link target " + linkable);
        }
    }

    private void port(ImmutablePortNode portNode) {
        Compass compass;
        this.str.append(portNode.name().serialized());
        String record = portNode.port().record();
        if (record != null) {
            this.str.append(':').append(SimpleLabel.of(record).serialized());
        }
        if ((compass = portNode.port().compass()) != null) {
            this.str.append(':').append(compass.value);
        }
    }

    private void attrs(MutableAttributed<?, ?> attrs) {
        if (!attrs.isEmpty()) {
            this.str.append(" [");
            boolean first = true;
            for (Map.Entry entry : attrs) {
                if (first) {
                    first = false;
                } else {
                    this.str.append(',');
                }
                this.attr((String)entry.getKey(), entry.getValue());
            }
            this.str.append(']');
        }
    }

    private void attr(String key, Object value) {
        this.str.append(SimpleLabel.of(key).serialized()).append('=').append(SimpleLabel.of(value).serialized());
    }
}

