/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.rough;

import java.util.HashMap;
import java.util.Map;

public class FillStyle {
    private static final String FILL_WEIGHT = "fillWeight";
    private static final String HACHURE_ANGLE = "hachureAngle";
    private static final String HACHURE_GAP = "hachureGap";
    protected Map<String, Object> values = new HashMap<String, Object>();

    private FillStyle(String style) {
        this.values.put("fillStyle", style);
    }

    public static Hachure hachure() {
        return new Hachure();
    }

    public static CrossHatch crossHatch() {
        return new CrossHatch();
    }

    public static FillStyle solid() {
        return new FillStyle("solid");
    }

    public static Zigzag zigzag() {
        return new Zigzag();
    }

    public static ZigzagLine zigzagLine() {
        return new ZigzagLine();
    }

    public static Dots dots() {
        return new Dots();
    }

    public static Starburst starburst() {
        return new Starburst();
    }

    public static Dashed dashed() {
        return new Dashed();
    }

    public static class Dashed
    extends FillStyle {
        Dashed() {
            super("dashed");
        }

        public Dashed width(double size) {
            this.values.put(FillStyle.FILL_WEIGHT, size);
            return this;
        }

        public Dashed angle(double angle) {
            this.values.put(FillStyle.HACHURE_ANGLE, angle);
            return this;
        }

        public Dashed gap(double gap) {
            this.values.put(FillStyle.HACHURE_GAP, gap);
            return this;
        }

        public Dashed length(double length) {
            this.values.put("dashOffset", length);
            return this;
        }
    }

    public static class Dots
    extends FillStyle {
        Dots() {
            super("dots");
        }

        public Dots size(double size) {
            this.values.put(FillStyle.FILL_WEIGHT, size);
            return this;
        }
    }

    public static class Starburst
    extends FillStyle {
        Starburst() {
            super("starburst");
        }

        public Starburst width(double width) {
            this.values.put(FillStyle.FILL_WEIGHT, width);
            return this;
        }

        public Starburst gap(double gap) {
            this.values.put(FillStyle.HACHURE_GAP, gap);
            return this;
        }
    }

    public static class ZigzagLine
    extends FillStyle {
        ZigzagLine() {
            super("zigzag-line");
        }

        public ZigzagLine width(double width) {
            this.values.put(FillStyle.FILL_WEIGHT, width);
            return this;
        }

        public ZigzagLine angle(double angle) {
            this.values.put(FillStyle.HACHURE_ANGLE, angle);
            return this;
        }

        public ZigzagLine gap(double gap) {
            this.values.put(FillStyle.HACHURE_GAP, gap);
            return this;
        }

        public ZigzagLine size(double size) {
            this.values.put("zigzagOffset", size);
            return this;
        }
    }

    public static class Zigzag
    extends FillStyle {
        Zigzag() {
            super("zigzag");
        }

        public Zigzag width(double width) {
            this.values.put(FillStyle.FILL_WEIGHT, width);
            return this;
        }

        public Zigzag angle(double angle) {
            this.values.put(FillStyle.HACHURE_ANGLE, angle);
            return this;
        }

        public Zigzag gap(double gap) {
            this.values.put(FillStyle.HACHURE_GAP, gap);
            return this;
        }
    }

    public static class CrossHatch
    extends FillStyle {
        CrossHatch() {
            super("cross-hatch");
        }

        public CrossHatch width(double width) {
            this.values.put(FillStyle.FILL_WEIGHT, width);
            return this;
        }

        public CrossHatch angle(double angle) {
            this.values.put(FillStyle.HACHURE_ANGLE, angle);
            return this;
        }

        public CrossHatch gap(double gap) {
            this.values.put(FillStyle.HACHURE_GAP, gap);
            return this;
        }
    }

    public static class Hachure
    extends FillStyle {
        Hachure() {
            super("hachure");
        }

        public Hachure width(double width) {
            this.values.put(FillStyle.FILL_WEIGHT, width);
            return this;
        }

        public Hachure angle(double angle) {
            this.values.put(FillStyle.HACHURE_ANGLE, angle);
            return this;
        }

        public Hachure gap(double gap) {
            this.values.put(FillStyle.HACHURE_GAP, gap);
            return this;
        }
    }
}

