/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.event;

import ie.omk.smpp.Connection;
import ie.omk.smpp.event.ConnectionObserver;
import ie.omk.smpp.event.EventDispatcher;
import ie.omk.smpp.event.SMPPEvent;
import ie.omk.smpp.message.SMPPPacket;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleEventDispatcher
implements EventDispatcher {
    public static final int INCREMENT = 3;
    private static final Log LOGGER;
    private ConnectionObserver[] observers;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SimpleEventDispatcher() {
        this.observers = new ConnectionObserver[3];
    }

    public SimpleEventDispatcher(ConnectionObserver ob) {
        this.observers = new ConnectionObserver[1];
        this.addObserver(ob);
    }

    public void init() {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(ConnectionObserver ob) {
        ConnectionObserver[] connectionObserverArray = this.observers;
        synchronized (this.observers) {
            if (this.indexOf(ob) < 0) {
                int index = this.findSlot();
                if (index < 0) {
                    this.growArray(ob);
                } else {
                    this.observers[index] = ob;
                }
            } else {
                LOGGER.info((Object)"Not adding observer because it's already registered");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(ConnectionObserver ob) {
        ConnectionObserver[] connectionObserverArray = this.observers;
        synchronized (this.observers) {
            int index = this.indexOf(ob);
            if (index > -1) {
                this.observers[index] = null;
            } else {
                LOGGER.info((Object)"Cannot remove an observer that was not added");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator observerIterator() {
        ConnectionObserver[] connectionObserverArray = this.observers;
        synchronized (this.observers) {
            ArrayList<ConnectionObserver> list = new ArrayList<ConnectionObserver>(this.observers.length);
            for (int i = 0; i < this.observers.length; ++i) {
                if (this.observers[i] == null) continue;
                list.add(this.observers[i]);
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return list.iterator();
        }
    }

    public boolean contains(ConnectionObserver ob) {
        return this.indexOf(ob) > -1;
    }

    public void notifyObservers(Connection conn, SMPPEvent event) {
        for (int i = 0; i < this.observers.length; ++i) {
            ConnectionObserver obs = this.observers[i];
            if (obs == null) continue;
            try {
                obs.update(conn, event);
                continue;
            }
            catch (Throwable t) {
                LOGGER.warn((Object)"An observer threw an exception during event processing", t);
            }
        }
    }

    public void notifyObservers(Connection conn, SMPPPacket packet) {
        for (int i = 0; i < this.observers.length; ++i) {
            ConnectionObserver obs = this.observers[i];
            if (obs == null) continue;
            try {
                obs.packetReceived(conn, packet);
                continue;
            }
            catch (Throwable t) {
                LOGGER.warn((Object)"An observer threw an exception during packet processing", t);
            }
        }
    }

    public int capacity() {
        return this.observers.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int size = 0;
        ConnectionObserver[] connectionObserverArray = this.observers;
        synchronized (this.observers) {
            for (int i = 0; i < this.observers.length; ++i) {
                if (this.observers[i] == null) continue;
                ++size;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return size;
        }
    }

    void growArray(ConnectionObserver ob) {
        if (!$assertionsDisabled && !Thread.holdsLock(this.observers)) {
            throw new AssertionError();
        }
        ConnectionObserver[] newArray = new ConnectionObserver[this.observers.length + 3];
        System.arraycopy(this.observers, 0, newArray, 0, this.observers.length);
        newArray[this.observers.length] = ob;
        this.observers = newArray;
    }

    private int findSlot() {
        int i;
        if (!$assertionsDisabled && !Thread.holdsLock(this.observers)) {
            throw new AssertionError();
        }
        for (i = 0; i < this.observers.length && this.observers[i] != null; ++i) {
        }
        if (i == this.observers.length) {
            i = -1;
        }
        return i;
    }

    private int indexOf(ConnectionObserver obs) {
        for (int i = this.observers.length - 1; i >= 0; --i) {
            if (this.observers[i] != obs) continue;
            return i;
        }
        return -1;
    }

    static {
        $assertionsDisabled = !SimpleEventDispatcher.class.desiredAssertionStatus();
        LOGGER = LogFactory.getLog((Class)SimpleEventDispatcher.class);
    }
}

