/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.event;

import ie.omk.smpp.Connection;
import ie.omk.smpp.event.ConnectionObserver;
import ie.omk.smpp.event.EventDispatcher;
import ie.omk.smpp.event.FIFOQueue;
import ie.omk.smpp.event.NotificationDetails;
import ie.omk.smpp.event.SMPPEvent;
import ie.omk.smpp.message.SMPPPacket;
import ie.omk.smpp.util.APIConfig;
import ie.omk.smpp.util.PropertyNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadedEventDispatcher
implements EventDispatcher,
Runnable {
    private static final Log LOGGER = LogFactory.getLog((Class)ThreadedEventDispatcher.class);
    private boolean running = true;
    private int poolSize;
    private ThreadGroup threadPool = new ThreadGroup("DispatcherPool");
    private FIFOQueue queue;
    private int threadsWaiting;
    private List observers = new ArrayList();

    public void init() {
        int queueSize;
        try {
            APIConfig cfg = APIConfig.getInstance();
            this.poolSize = cfg.getInt("smppapi.event.threaded_dispatcher.pool_size");
            queueSize = cfg.getInt("smppapi.event.threaded_dispatcher.queue_size");
        }
        catch (PropertyNotFoundException x) {
            this.poolSize = 3;
            queueSize = 100;
        }
        this.queue = new FIFOQueue(queueSize);
        this.initialiseThreadPool();
    }

    private void initialiseThreadPool() {
        for (int i = 0; i < this.poolSize; ++i) {
            Thread t = new Thread(this.threadPool, this, "EventDispatch" + i);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroy() {
        LOGGER.debug((Object)"Shutting down dispatch threads.");
        if (Thread.currentThread().getThreadGroup() == this.threadPool) {
            LOGGER.error((Object)"Cannot shut down the thread pool with one of it's own threads.");
            throw new RuntimeException();
        }
        this.running = false;
        FIFOQueue fIFOQueue = this.queue;
        synchronized (fIFOQueue) {
            this.queue.notifyAll();
        }
        LOGGER.info((Object)"Waiting for threads in pool to die.");
        int waitTime = 50;
        int times = 20;
        int time = 0;
        Thread[] pool = new Thread[this.poolSize];
        block6: while (true) {
            try {
                while (true) {
                    pool[0] = null;
                    this.threadPool.enumerate(pool, false);
                    if (pool[0] == null) break block6;
                    LOGGER.debug((Object)"There's still some threads running. Doing another loop..");
                    if (time >= 20) break block6;
                    Thread.sleep(50L);
                    FIFOQueue fIFOQueue2 = this.queue;
                    synchronized (fIFOQueue2) {
                        this.queue.notifyAll();
                    }
                }
            }
            catch (InterruptedException x) {
                this.threadPool.interrupt();
                Thread.yield();
                continue;
            }
            break;
        }
        if (this.threadPool.activeCount() > 0) {
            LOGGER.error((Object)(this.threadPool.activeCount() + " dispatcher threads refused to die."));
            if (LOGGER.isDebugEnabled()) {
                Thread[] threads = new Thread[this.threadPool.activeCount()];
                this.threadPool.enumerate(threads, false);
                for (int i = 0; i < pool.length; ++i) {
                    LOGGER.debug((Object)pool[i].getName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(ConnectionObserver observer) {
        List list = this.observers;
        synchronized (list) {
            if (!this.observers.contains(observer)) {
                this.observers.add(observer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(ConnectionObserver observer) {
        List list = this.observers;
        synchronized (list) {
            this.observers.remove(observer);
        }
    }

    public Iterator observerIterator() {
        return Collections.unmodifiableList(this.observers).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(ConnectionObserver observer) {
        List list = this.observers;
        synchronized (list) {
            return this.observers.contains(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(Connection conn, SMPPEvent e) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Notifying observers of a new SMPP event " + e.getType()));
        }
        this.queue.put(conn, e);
        if (this.threadsWaiting > 0) {
            FIFOQueue fIFOQueue = this.queue;
            synchronized (fIFOQueue) {
                this.queue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(Connection conn, SMPPPacket pak) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Notifying observers of a new SMPP packet (" + Integer.toHexString(pak.getCommandId()) + "," + Integer.toString(pak.getSequenceNum()) + ")"));
        }
        this.queue.put(conn, pak);
        if (this.threadsWaiting > 0) {
            FIFOQueue fIFOQueue = this.queue;
            synchronized (fIFOQueue) {
                this.queue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Thread start: " + Thread.currentThread().getName()));
            }
            while (this.running) {
                NotificationDetails nd = null;
                try {
                    FIFOQueue fIFOQueue = this.queue;
                    synchronized (fIFOQueue) {
                        if (this.queue.isEmpty()) {
                            ++this.threadsWaiting;
                            this.queue.wait();
                            --this.threadsWaiting;
                        }
                        nd = this.queue.get();
                    }
                }
                catch (InterruptedException x) {
                    continue;
                }
                if (nd == null) continue;
                for (int i = this.observers.size() - 1; i >= 0; --i) {
                    ConnectionObserver observer = (ConnectionObserver)this.observers.get(i);
                    if (nd.hasEvent()) {
                        observer.packetReceived(nd.getConnection(), nd.getPacket());
                        continue;
                    }
                    observer.update(nd.getConnection(), nd.getEvent());
                }
            }
            LOGGER.debug((Object)("Thread exit: " + Thread.currentThread().getName()));
        }
        catch (Exception x) {
            LOGGER.warn((Object)"Exception in dispatcher thread", (Throwable)x);
        }
    }
}

