/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message;

import ie.omk.smpp.message.Bind;
import ie.omk.smpp.message.InvalidParameterValueException;
import ie.omk.smpp.message.SMPPProtocolException;
import ie.omk.smpp.message.SMPPResponse;
import ie.omk.smpp.util.SMPPIO;
import java.io.IOException;
import java.io.OutputStream;

public abstract class BindResp
extends SMPPResponse {
    private String sysId;

    protected BindResp(int id) {
        super(id);
    }

    public BindResp(Bind req) {
        super(req);
    }

    public void setSystemId(String sysId) throws InvalidParameterValueException {
        if (sysId != null) {
            if (!this.version.validateSystemId(sysId)) {
                throw new InvalidParameterValueException("Invalid system Id", sysId);
            }
        } else {
            this.sysId = null;
            return;
        }
        this.sysId = sysId;
    }

    public String getSystemId() {
        return this.sysId;
    }

    public int getBodyLength() {
        return (this.sysId != null ? this.sysId.length() : 0) + 1;
    }

    protected void encodeBody(OutputStream out) throws IOException {
        SMPPIO.writeCString(this.sysId, out);
    }

    public void readBodyFrom(byte[] body, int offset) throws SMPPProtocolException {
        this.sysId = SMPPIO.readCString(body, offset);
    }

    public String toString() {
        return new String("bind_resp");
    }
}

