/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message;

import ie.omk.smpp.Address;
import ie.omk.smpp.message.SMPPProtocolException;
import ie.omk.smpp.message.SMPPRequest;
import ie.omk.smpp.util.SMPPIO;
import java.io.IOException;
import java.io.OutputStream;

public class CancelSM
extends SMPPRequest {
    public CancelSM() {
        super(8);
    }

    public CancelSM(int seqNum) {
        super(8, seqNum);
    }

    public int getBodyLength() {
        int len = (this.serviceType != null ? this.serviceType.length() : 0) + (this.messageId != null ? this.messageId.length() : 0) + (this.source != null ? this.source.getLength() : 3) + (this.destination != null ? this.destination.getLength() : 3);
        return len + 2;
    }

    protected void encodeBody(OutputStream out) throws IOException {
        SMPPIO.writeCString(this.serviceType, out);
        SMPPIO.writeCString(this.getMessageId(), out);
        if (this.source != null) {
            this.source.writeTo(out);
        } else {
            new Address(0, 0, "").writeTo(out);
        }
        if (this.destination != null) {
            this.destination.writeTo(out);
        } else {
            new Address(0, 0, "").writeTo(out);
        }
    }

    public void readBodyFrom(byte[] body, int offset) throws SMPPProtocolException {
        this.serviceType = SMPPIO.readCString(body, offset);
        this.messageId = SMPPIO.readCString(body, offset += this.serviceType.length() + 1);
        this.source = new Address();
        this.source.readFrom(body, offset += this.messageId.length() + 1);
        this.destination = new Address();
        this.destination.readFrom(body, offset += this.source.getLength());
    }

    public String toString() {
        return new String("cancel_sm");
    }
}

