/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message;

import ie.omk.smpp.Address;
import ie.omk.smpp.message.SMPPProtocolException;
import ie.omk.smpp.message.SMPPRequest;
import ie.omk.smpp.util.SMPPIO;
import java.io.IOException;
import java.io.OutputStream;

public class DataSM
extends SMPPRequest {
    public DataSM() {
        super(259);
    }

    public DataSM(int seqNum) {
        super(259, seqNum);
    }

    public int getBodyLength() {
        int len = (this.serviceType != null ? this.serviceType.length() : 0) + (this.source != null ? this.source.getLength() : 3) + (this.destination != null ? this.destination.getLength() : 3);
        return len + 4;
    }

    protected void encodeBody(OutputStream out) throws IOException {
        SMPPIO.writeCString(this.serviceType, out);
        if (this.source != null) {
            this.source.writeTo(out);
        } else {
            new Address(0, 0, "").writeTo(out);
        }
        if (this.destination != null) {
            this.destination.writeTo(out);
        } else {
            new Address(0, 0, "").writeTo(out);
        }
        SMPPIO.writeInt(this.esmClass, 1, out);
        SMPPIO.writeInt(this.registered, 1, out);
        SMPPIO.writeInt(this.dataCoding, 1, out);
    }

    public void readBodyFrom(byte[] body, int offset) throws SMPPProtocolException {
        this.serviceType = SMPPIO.readCString(body, offset);
        this.source = new Address();
        this.source.readFrom(body, offset += this.serviceType.length() + 1);
        this.destination = new Address();
        this.destination.readFrom(body, offset += this.source.getLength());
        offset += this.destination.getLength();
        this.esmClass = SMPPIO.bytesToInt(body, offset++, 1);
        this.registered = SMPPIO.bytesToInt(body, offset++, 1);
        this.dataCoding = SMPPIO.bytesToInt(body, offset++, 1);
    }

    public String toString() {
        return new String("data_sm");
    }
}

