/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message;

import ie.omk.smpp.message.InvalidParameterValueException;
import ie.omk.smpp.message.ParamRetrieve;
import ie.omk.smpp.message.SMPPProtocolException;
import ie.omk.smpp.message.SMPPResponse;
import ie.omk.smpp.util.SMPPIO;
import java.io.IOException;
import java.io.OutputStream;

public class ParamRetrieveResp
extends SMPPResponse {
    private String paramValue;

    public ParamRetrieveResp() {
        super(-2147483614);
        this.paramValue = null;
    }

    public ParamRetrieveResp(int seqNum) {
        super(-2147483614, seqNum);
        this.paramValue = null;
    }

    public ParamRetrieveResp(ParamRetrieve r) {
        super(r);
    }

    public void setParamValue(String v) throws InvalidParameterValueException {
        if (v == null) {
            this.paramValue = null;
            return;
        }
        if (v.length() >= 101) {
            throw new InvalidParameterValueException("Parameter value is too long", v);
        }
        this.paramValue = v;
    }

    public String getParamValue() {
        return this.paramValue;
    }

    public int getBodyLength() {
        int len = this.paramValue != null ? this.paramValue.length() : 0;
        return len + 1;
    }

    protected void encodeBody(OutputStream out) throws IOException {
        SMPPIO.writeCString(this.paramValue, out);
    }

    public void readBodyFrom(byte[] body, int offset) throws SMPPProtocolException {
        this.paramValue = SMPPIO.readCString(body, offset);
    }

    public String toString() {
        return new String("param_retrieve_resp");
    }
}

