/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message;

import ie.omk.smpp.message.QuerySM;
import ie.omk.smpp.message.SMPPProtocolException;
import ie.omk.smpp.message.SMPPResponse;
import ie.omk.smpp.util.InvalidDateFormatException;
import ie.omk.smpp.util.SMPPDate;
import ie.omk.smpp.util.SMPPIO;
import java.io.IOException;
import java.io.OutputStream;

public class QuerySMResp
extends SMPPResponse {
    public QuerySMResp() {
        super(-2147483645);
    }

    public QuerySMResp(int seqNum) {
        super(-2147483645, seqNum);
    }

    public QuerySMResp(QuerySM r) {
        super(r);
        this.messageId = r.getMessageId();
        this.finalDate = null;
        this.messageStatus = 0;
        this.errorCode = 0;
    }

    public int getBodyLength() {
        int len = (this.messageId != null ? this.messageId.length() : 0) + (this.finalDate != null ? this.finalDate.toString().length() : 0);
        return len + 2 + 2;
    }

    protected void encodeBody(OutputStream out) throws IOException {
        String fdate = this.finalDate == null ? null : this.finalDate.toString();
        SMPPIO.writeCString(this.getMessageId(), out);
        SMPPIO.writeCString(fdate, out);
        SMPPIO.writeInt(this.messageStatus, 1, out);
        SMPPIO.writeInt(this.errorCode, 1, out);
    }

    public void readBodyFrom(byte[] body, int offset) throws SMPPProtocolException {
        try {
            this.messageId = SMPPIO.readCString(body, offset);
            String finald = SMPPIO.readCString(body, offset += this.messageId.length() + 1);
            offset += finald.length() + 1;
            if (finald.length() > 0) {
                this.finalDate = SMPPDate.parseSMPPDate(finald);
            }
            this.messageStatus = SMPPIO.bytesToInt(body, offset++, 1);
            this.errorCode = SMPPIO.bytesToInt(body, offset++, 1);
        }
        catch (InvalidDateFormatException x) {
            throw new SMPPProtocolException("Unrecognized date format", x);
        }
    }

    public String toString() {
        return new String("query_sm_resp");
    }
}

