/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message;

import ie.omk.smpp.Address;
import ie.omk.smpp.message.SMPPProtocolException;
import ie.omk.smpp.message.SMPPRequest;
import ie.omk.smpp.util.InvalidDateFormatException;
import ie.omk.smpp.util.SMPPDate;
import ie.omk.smpp.util.SMPPIO;
import java.io.IOException;
import java.io.OutputStream;

public class SubmitSM
extends SMPPRequest {
    public SubmitSM() {
        super(4);
    }

    public SubmitSM(int seqNum) {
        super(4, seqNum);
    }

    public int getBodyLength() {
        int len = (this.serviceType != null ? this.serviceType.length() : 0) + (this.source != null ? this.source.getLength() : 3) + (this.destination != null ? this.destination.getLength() : 3) + (this.deliveryTime != null ? this.deliveryTime.toString().length() : 0) + (this.expiryTime != null ? this.expiryTime.toString().length() : 0) + (this.message != null ? this.message.length : 0);
        return len + 8 + 3;
    }

    protected void encodeBody(OutputStream out) throws IOException {
        int smLength = 0;
        if (this.message != null) {
            smLength = this.message.length;
        }
        SMPPIO.writeCString(this.serviceType, out);
        if (this.source != null) {
            this.source.writeTo(out);
        } else {
            new Address(0, 0, "").writeTo(out);
        }
        if (this.destination != null) {
            this.destination.writeTo(out);
        } else {
            new Address(0, 0, "").writeTo(out);
        }
        String dt = this.deliveryTime == null ? "" : this.deliveryTime.toString();
        String et = this.expiryTime == null ? "" : this.expiryTime.toString();
        SMPPIO.writeInt(this.esmClass, 1, out);
        SMPPIO.writeInt(this.protocolID, 1, out);
        SMPPIO.writeInt(this.priority, 1, out);
        SMPPIO.writeCString(dt, out);
        SMPPIO.writeCString(et, out);
        SMPPIO.writeInt(this.registered, 1, out);
        SMPPIO.writeInt(this.replaceIfPresent, 1, out);
        SMPPIO.writeInt(this.dataCoding, 1, out);
        SMPPIO.writeInt(this.defaultMsg, 1, out);
        SMPPIO.writeInt(smLength, 1, out);
        if (this.message != null) {
            out.write(this.message);
        }
    }

    public void readBodyFrom(byte[] body, int offset) throws SMPPProtocolException {
        try {
            int smLength = 0;
            this.serviceType = SMPPIO.readCString(body, offset);
            this.source = new Address();
            this.source.readFrom(body, offset += this.serviceType.length() + 1);
            this.destination = new Address();
            this.destination.readFrom(body, offset += this.source.getLength());
            offset += this.destination.getLength();
            this.esmClass = SMPPIO.bytesToInt(body, offset++, 1);
            this.protocolID = SMPPIO.bytesToInt(body, offset++, 1);
            this.priority = SMPPIO.bytesToInt(body, offset++, 1);
            String delivery = SMPPIO.readCString(body, offset);
            offset += delivery.length() + 1;
            if (delivery.length() > 0) {
                this.deliveryTime = SMPPDate.parseSMPPDate(delivery);
            }
            String valid = SMPPIO.readCString(body, offset);
            offset += valid.length() + 1;
            if (valid.length() > 0) {
                this.expiryTime = SMPPDate.parseSMPPDate(valid);
            }
            this.registered = SMPPIO.bytesToInt(body, offset++, 1);
            this.replaceIfPresent = SMPPIO.bytesToInt(body, offset++, 1);
            this.dataCoding = SMPPIO.bytesToInt(body, offset++, 1);
            this.defaultMsg = SMPPIO.bytesToInt(body, offset++, 1);
            if ((smLength = SMPPIO.bytesToInt(body, offset++, 1)) > 0) {
                this.message = new byte[smLength];
                System.arraycopy(body, offset, this.message, 0, smLength);
            }
        }
        catch (InvalidDateFormatException x) {
            throw new SMPPProtocolException("Unrecognized date format", x);
        }
    }

    public String toString() {
        return new String("submit_sm");
    }
}

