/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message.tlv;

import ie.omk.smpp.message.tlv.Encoder;
import ie.omk.smpp.message.tlv.Tag;
import java.io.UnsupportedEncodingException;

public class StringEncoder
implements Encoder {
    private static final String ASCII_UNSUPPORTED_MSG = "Your JVM doesn't support ASCII!";
    private static final String ASCII = "US-ASCII";

    public void writeTo(Tag tag, Object value, byte[] b, int offset) {
        try {
            String s = value.toString();
            int len = s.length();
            byte[] b1 = s.getBytes(ASCII);
            System.arraycopy(b1, 0, b, offset, len);
            b[offset + len] = 0;
        }
        catch (UnsupportedEncodingException x) {
            throw new RuntimeException(ASCII_UNSUPPORTED_MSG);
        }
    }

    public Object readFrom(Tag tag, byte[] b, int offset, int length) {
        try {
            String s = new String(b, offset, length - 1, ASCII);
            return s;
        }
        catch (UnsupportedEncodingException x) {
            throw new RuntimeException(ASCII_UNSUPPORTED_MSG);
        }
    }

    public int getValueLength(Tag tag, Object value) {
        return value.toString().length() + 1;
    }
}

