/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.message.tlv;

import ie.omk.smpp.message.tlv.BitmaskEncoder;
import ie.omk.smpp.message.tlv.Encoder;
import ie.omk.smpp.message.tlv.NoEncoderException;
import ie.omk.smpp.message.tlv.NullEncoder;
import ie.omk.smpp.message.tlv.NumberEncoder;
import ie.omk.smpp.message.tlv.OctetEncoder;
import ie.omk.smpp.message.tlv.StringEncoder;
import ie.omk.smpp.message.tlv.TagDefinedException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public final class Tag
implements Serializable {
    private static Map tagTable = new HashMap();
    static final long serialVersionUID = -418561932897398277L;
    public static final Tag DEST_ADDR_SUBUNIT = new Tag(5, Number.class, 1);
    public static final Tag DEST_NETWORK_TYPE = new Tag(6, Number.class, 1);
    public static final Tag DEST_BEARER_TYPE = new Tag(7, Number.class, 1);
    public static final Tag DEST_TELEMATICS_ID = new Tag(8, Number.class, 2);
    public static final Tag SOURCE_ADDR_SUBUNIT = new Tag(13, Number.class, 1);
    public static final Tag SOURCE_NETWORK_TYPE = new Tag(14, Number.class, 1);
    public static final Tag SOURCE_BEARER_TYPE = new Tag(15, Number.class, 1);
    public static final Tag SOURCE_TELEMATICS_ID = new Tag(16, Number.class, 1);
    public static final Tag QOS_TIME_TO_LIVE = new Tag(23, Number.class, 4);
    public static final Tag PAYLOAD_TYPE = new Tag(25, Number.class, 1);
    public static final Tag ADDITIONAL_STATUS_INFO_TEXT = new Tag(29, String.class, 1, 256);
    public static final Tag RECEIPTED_MESSAGE_ID = new Tag(30, String.class, 1, 65);
    public static final Tag MS_MSG_WAIT_FACILITIES = new Tag(48, BitSet.class, 1);
    public static final Tag PRIVACY_INDICATOR = new Tag(513, Number.class, 1);
    public static final Tag SOURCE_SUBADDRESS = new Tag(514, [B.class, 2, 23);
    public static final Tag DEST_SUBADDRESS = new Tag(515, [B.class, 2, 23);
    public static final Tag USER_MESSAGE_REFERENCE = new Tag(516, Number.class, 2);
    public static final Tag USER_RESPONSE_CODE = new Tag(517, Number.class, 1);
    public static final Tag SOURCE_PORT = new Tag(522, Number.class, 2);
    public static final Tag DESTINATION_PORT = new Tag(523, Number.class, 2);
    public static final Tag SAR_MSG_REF_NUM = new Tag(524, Number.class, 2);
    public static final Tag LANGUAGE_INDICATOR = new Tag(525, Number.class, 1);
    public static final Tag SAR_TOTAL_SEGMENTS = new Tag(526, Number.class, 1);
    public static final Tag SAR_SEGMENT_SEQNUM = new Tag(527, Number.class, 1);
    public static final Tag SC_INTERFACE_VERSION = new Tag(528, Number.class, 1);
    public static final Tag CALLBACK_NUM_PRES_IND = new Tag(770, BitSet.class, 1);
    public static final Tag CALLBACK_NUM_ATAG = new Tag(771, [B.class, 0, 65);
    public static final Tag NUMBER_OF_MESSAGES = new Tag(772, Number.class, 1);
    public static final Tag CALLBACK_NUM = new Tag(897, [B.class, 4, 19);
    public static final Tag DPF_RESULT = new Tag(1056, Number.class, 1);
    public static final Tag SET_DPF = new Tag(1057, Number.class, 1);
    public static final Tag MS_AVAILABILITY_STATUS = new Tag(1058, Number.class, 1);
    public static final Tag NETWORK_ERROR_CODE = new Tag(1059, [B.class, 3);
    public static final Tag MESSAGE_PAYLOAD = new Tag(1060, [B.class, -1);
    public static final Tag DELIVERY_FAILURE_REASON = new Tag(1061, Number.class, 1);
    public static final Tag MORE_MESSAGES_TO_SEND = new Tag(1062, Number.class, 1);
    public static final Tag MESSAGE_STATE = new Tag(1063, Number.class, 1);
    public static final Tag USSD_SERVICE_OP = new Tag(1281, [B.class, 1);
    public static final Tag DISPLAY_TIME = new Tag(4609, Number.class, 1);
    public static final Tag SMS_SIGNAL = new Tag(4611, Number.class, 2);
    public static final Tag MS_VALIDITY = new Tag(4612, Number.class, 1);
    public static final Tag ALERT_ON_MESSAGE_DELIVERY = new Tag(4876, null, 0);
    public static final Tag ITS_REPLY_TYPE = new Tag(4992, Number.class, 1);
    public static final Tag ITS_SESSION_INFO = new Tag(4995, [B.class, 2);
    private Integer tag;
    private int minLength = -1;
    private int maxLength = -1;
    private Class type;
    private Encoder encoder;

    private Tag(int tag, Class type, int fixedLength) throws TagDefinedException {
        this(tag, type, null, fixedLength, fixedLength);
    }

    private Tag(int tag, Class type, int minLength, int maxLength) throws TagDefinedException {
        this(tag, type, null, minLength, maxLength);
    }

    private Tag(int tag, Class type, Encoder enc, int fixedLength) throws TagDefinedException {
        this(tag, type, enc, fixedLength, fixedLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tag(int tag, Class type, Encoder enc, int minLength, int maxLength) throws TagDefinedException {
        this.tag = new Integer(tag);
        this.type = type;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.encoder = enc == null ? this.getEncoderForType(type) : enc;
        Map map = tagTable;
        synchronized (map) {
            if (tagTable.containsKey(this.tag)) {
                throw new TagDefinedException(tag, "Tag 0x" + Integer.toHexString(tag) + " is already defined.");
            }
            tagTable.put(this.tag, this);
        }
    }

    private Encoder getEncoderForType(Class type) {
        Encoder encoder;
        if (type == null) {
            encoder = new NullEncoder();
        } else if (Number.class.isAssignableFrom(type)) {
            encoder = new NumberEncoder();
        } else if (String.class.isAssignableFrom(type)) {
            encoder = new StringEncoder();
        } else if (BitSet.class.isAssignableFrom(type)) {
            encoder = new BitmaskEncoder();
        } else if ([B.class.isAssignableFrom(type)) {
            encoder = new OctetEncoder();
        } else {
            throw new NoEncoderException(type, "No encoder for class type " + type.getName());
        }
        return encoder;
    }

    public int intValue() {
        return this.tag;
    }

    public int getLength() {
        return this.maxLength < 0 ? this.minLength : this.maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public Class getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Tag) {
            return ((Tag)obj).tag.equals(this.tag);
        }
        return false;
    }

    public boolean equals(int tag) {
        return tag == this.tag;
    }

    public int hashCode() {
        return this.tag.hashCode();
    }

    public String toString() {
        return this.tag.toString();
    }

    public String toHexString() {
        return Integer.toHexString(this.tag);
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public static Tag getTag(int tagValue) {
        Tag t = (Tag)tagTable.get(new Integer(tagValue));
        if (t == null) {
            return Tag.defineTag(tagValue, [B.class, null, -1, -1);
        }
        return t;
    }

    public static Tag defineTag(int tagValue, Class type, Encoder enc, int fixedSize) throws TagDefinedException {
        return new Tag(tagValue, type, enc, fixedSize);
    }

    public static Tag defineTag(int tagValue, Class type, Encoder enc, int minSize, int maxSize) throws TagDefinedException {
        return new Tag(tagValue, type, enc, minSize, maxSize);
    }

    public static boolean isTagDefined(int tagValue) {
        return tagTable.containsKey(new Integer(tagValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tag undefineTag(Tag tag) {
        if (tag == null) {
            return null;
        }
        Map map = tagTable;
        synchronized (map) {
            return (Tag)tagTable.remove(tag.tag);
        }
    }
}

