/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.net;

import ie.omk.smpp.message.SMPPPacket;
import ie.omk.smpp.util.APIConfig;
import ie.omk.smpp.util.PropertyNotFoundException;
import ie.omk.smpp.util.SMPPIO;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SmscLink {
    private static final String TIMEOUT_UNSUPPORTED_ERR = "Timeout not supported";
    private static final String END_OF_STREAM_ERR = "EOS reached. No data available";
    private static final String LINK_NOT_UP_ERR = "Link not established.";
    private static final Log LOGGER;
    private BufferedInputStream in;
    private BufferedOutputStream out;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    private OutputStream snoopIn;
    private OutputStream snoopOut;
    private boolean autoFlush;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmscLink() {
        try {
            this.autoFlush = APIConfig.getInstance().getBoolean("smppapi.net.autoflush");
        }
        catch (PropertyNotFoundException x) {
            this.autoFlush = true;
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("autoFlush set to " + this.autoFlush));
            }
        }
    }

    public final void open() throws IOException {
        this.implOpen();
        int inSize = -1;
        int outSize = -1;
        APIConfig cfg = APIConfig.getInstance();
        inSize = this.getBufferSize(cfg, "smppapi.net.buffersize_in");
        outSize = this.getBufferSize(cfg, "smppapi.net.buffersize_out");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("IN buffer size: " + inSize));
            LOGGER.debug((Object)("OUT buffer size: " + outSize));
        }
        this.in = inSize < 1 ? new BufferedInputStream(this.getInputStream()) : new BufferedInputStream(this.getInputStream(), inSize);
        this.out = outSize < 1 ? new BufferedOutputStream(this.getOutputStream()) : new BufferedOutputStream(this.getOutputStream(), outSize);
    }

    private int getBufferSize(APIConfig cfg, String propName) {
        int size = -1;
        try {
            String s = cfg.getProperty(propName);
            size = s.toLowerCase().endsWith("k") ? Integer.parseInt(s.substring(0, s.length() - 1)) * 1024 : (s.toLowerCase().endsWith("m") ? Integer.parseInt(s.substring(0, s.length() - 1)) * 0x100000 : Integer.parseInt(s, 10));
        }
        catch (PropertyNotFoundException x) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Buffer size is not set in configuration: " + propName + ", using default."));
            }
        }
        catch (NumberFormatException x) {
            LOGGER.warn((Object)("Bad value for config property " + propName), (Throwable)x);
        }
        return size;
    }

    protected abstract void implOpen() throws IOException;

    public final void close() throws IOException {
        this.out = null;
        this.in = null;
        this.implClose();
        boolean autoClose = true;
        try {
            autoClose = APIConfig.getInstance().getBoolean("smppapi.net.autoclose_snoop");
        }
        catch (PropertyNotFoundException x) {
            LOGGER.debug((Object)("smppapi.net.autoclose_snoop property not found. Using the default of " + autoClose));
        }
        if (autoClose) {
            try {
                if (this.snoopOut != null) {
                    this.snoopOut.close();
                }
                if (this.snoopIn != null) {
                    this.snoopIn.close();
                }
            }
            catch (IOException x) {
                LOGGER.warn((Object)"Exception while closing snoop streams.", (Throwable)x);
            }
        } else {
            try {
                if (this.snoopOut != null) {
                    this.snoopOut.flush();
                }
                if (this.snoopIn != null) {
                    this.snoopIn.flush();
                }
            }
            catch (IOException x) {
                LOGGER.warn((Object)"Exception while flushing snoop streams.", (Throwable)x);
            }
        }
    }

    protected abstract void implClose() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(SMPPPacket pak, boolean withOptional) throws IOException {
        if (this.out == null) {
            throw new IOException(LINK_NOT_UP_ERR);
        }
        Object object = this.writeLock;
        synchronized (object) {
            try {
                if (this.snoopOut != null) {
                    pak.writeTo(this.snoopOut, withOptional);
                }
            }
            catch (IOException x) {
                LOGGER.warn((Object)"IOException writing to snoop output stream.", (Throwable)x);
            }
            pak.writeTo(this.out, withOptional);
            if (this.autoFlush) {
                this.out.flush();
            }
        }
    }

    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public boolean getAutoFlush() {
        return this.autoFlush;
    }

    public void setAutoFlush(boolean flush) {
        this.autoFlush = flush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(byte[] array) throws IOException {
        if (this.in == null) {
            throw new IOException(LINK_NOT_UP_ERR);
        }
        byte[] buf = array;
        int count = 0;
        Object object = this.readLock;
        synchronized (object) {
            try {
                count = this.readBytes(buf, 0, 4, 16);
                int cmdLen = SMPPIO.bytesToInt(buf, 0, 4);
                if (cmdLen > buf.length) {
                    byte[] newbuf = new byte[cmdLen];
                    System.arraycopy(buf, 0, newbuf, 0, count);
                    buf = newbuf;
                }
                int remaining = cmdLen - count;
                this.readBytes(buf, count, remaining, remaining);
            }
            finally {
                this.dump(this.snoopIn, array, 0, count);
            }
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int available() {
        try {
            Object object = this.readLock;
            synchronized (object) {
                return this.in != null ? this.in.available() : 0;
            }
        }
        catch (IOException x) {
            LOGGER.debug((Object)"IOException in available", (Throwable)x);
            return 0;
        }
    }

    private int readBytes(byte[] buf, int offset, int minimum, int maxLen) throws IOException {
        if (!$assertionsDisabled && !Thread.holdsLock(this.readLock)) {
            throw new AssertionError();
        }
        int ptr = this.in.read(buf, offset, maxLen);
        if (ptr < minimum) {
            if (ptr == -1) {
                throw new EOFException(END_OF_STREAM_ERR);
            }
            while (ptr < minimum) {
                int count = this.in.read(buf, offset + ptr, maxLen - ptr);
                if (count < 0) {
                    throw new EOFException(END_OF_STREAM_ERR);
                }
                ptr += count;
            }
        }
        return ptr;
    }

    private void dump(OutputStream s, byte[] b, int offset, int len) {
        try {
            if (s != null) {
                s.write(b, offset, len);
            }
        }
        catch (IOException x) {
            LOGGER.warn((Object)"Couldn't write incoming bytes to input snooper.", (Throwable)x);
        }
    }

    protected abstract OutputStream getOutputStream() throws IOException;

    protected abstract InputStream getInputStream() throws IOException;

    public abstract boolean isConnected();

    public void setTimeout(long timeout) {
        throw new UnsupportedOperationException(TIMEOUT_UNSUPPORTED_ERR);
    }

    public void setTimeout(int timeout) {
        throw new UnsupportedOperationException(TIMEOUT_UNSUPPORTED_ERR);
    }

    public int getTimeout() {
        throw new UnsupportedOperationException(TIMEOUT_UNSUPPORTED_ERR);
    }

    public void setSnoopStreams(OutputStream snoopIn, OutputStream snoopOut) {
        this.snoopIn = snoopIn;
        this.snoopOut = snoopOut;
    }

    static {
        $assertionsDisabled = !SmscLink.class.desiredAssertionStatus();
        LOGGER = LogFactory.getLog((Class)SmscLink.class);
    }
}

