/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.util;

import ie.omk.smpp.util.ASCIIEncoding;
import ie.omk.smpp.util.AlphabetEncoding;
import ie.omk.smpp.util.DefaultAlphabetEncoding;
import ie.omk.smpp.util.Latin1Encoding;
import ie.omk.smpp.util.UCS2Encoding;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public final class AlphabetFactory {
    private static final Map LANG_TO_ALPHABET = new HashMap();
    private static AlphabetEncoding defaultAlphabet;
    private static final String DEFAULT_ALPHABET_PROPNAME = "smpp.default_alphabet";

    private AlphabetFactory() {
    }

    public static AlphabetEncoding getDefaultAlphabet() {
        if (defaultAlphabet == null) {
            AlphabetFactory.init();
        }
        return defaultAlphabet;
    }

    private static void init() {
        String className = "";
        try {
            className = System.getProperty(DEFAULT_ALPHABET_PROPNAME);
            if (className != null) {
                Class<?> alphaClass = Class.forName(className);
                defaultAlphabet = (AlphabetEncoding)alphaClass.newInstance();
            } else {
                defaultAlphabet = new DefaultAlphabetEncoding();
            }
        }
        catch (Exception x) {
            LogFactory.getLog((Class)AlphabetFactory.class).warn((Object)("Couldn't load default alphabet " + className), (Throwable)x);
            defaultAlphabet = new DefaultAlphabetEncoding();
        }
    }

    public static AlphabetEncoding getAlphabet(String lang) {
        AlphabetEncoding enc = (AlphabetEncoding)LANG_TO_ALPHABET.get(lang);
        if (enc != null) {
            return enc;
        }
        return (AlphabetEncoding)LANG_TO_ALPHABET.get(null);
    }

    static {
        DefaultAlphabetEncoding gsmDefault = new DefaultAlphabetEncoding();
        try {
            LANG_TO_ALPHABET.put(null, new UCS2Encoding());
        }
        catch (UnsupportedEncodingException x) {
            try {
                LANG_TO_ALPHABET.put(null, new Latin1Encoding());
            }
            catch (UnsupportedEncodingException xx) {
                LANG_TO_ALPHABET.put(null, new ASCIIEncoding());
            }
        }
        LANG_TO_ALPHABET.put("en", gsmDefault);
        LANG_TO_ALPHABET.put("de", gsmDefault);
        LANG_TO_ALPHABET.put("fr", gsmDefault);
        LANG_TO_ALPHABET.put("it", gsmDefault);
        LANG_TO_ALPHABET.put("nl", gsmDefault);
        LANG_TO_ALPHABET.put("es", gsmDefault);
    }
}

