/*
 * Decompiled with CFR 0.152.
 */
package ie.omk.smpp.util;

import java.util.Hashtable;
import java.util.Map;

public final class GSMConstants {
    public static final int GSM_ERR_NONE = 0;
    public static final int GSM_ERR_P_UNKNOWN = 1;
    public static final int GSM_ERR_P_PROVISION = 11;
    public static final int GSM_ERR_T_BARRED = 13;
    public static final int GSM_ERR_P_CUG = 15;
    public static final int GSM_ERR_T_MSSUPPORT = 19;
    public static final int GSM_ERR_T_MSERROR = 20;
    public static final int GSM_ERR_T_SUPPORT = 21;
    public static final int GSM_ERR_T_MEMCAP = 22;
    public static final int GSM_ERR_T_ABSENT = 29;
    public static final int GSM_ERR_T_ABSENT_DETACHED = 30;
    public static final int GSM_ERR_T_ABSENT_PAGEFAIL = 31;
    public static final int GSM_ERR_T_SUPPORT_ROAMING = 32;
    public static final int GSM_ERR_T_SYSTEM = 36;
    public static final int GSM_TON_UNKNOWN = 0;
    public static final int GSM_TON_INTERNATIONAL = 1;
    public static final int GSM_TON_NATIONAL = 2;
    public static final int GSM_TON_NETWORK = 3;
    public static final int GSM_TON_SUBSCRIBER = 4;
    public static final int GSM_TON_ALPHANUMERIC = 5;
    public static final int GSM_TON_ABBREVIATED = 6;
    public static final int GSM_TON_RESERVED_EXTN = 7;
    public static final int GSM_NPI_UNKNOWN = 0;
    public static final int GSM_NPI_E164 = 1;
    public static final int GSM_NPI_ISDN = 1;
    public static final int GSM_NPI_X121 = 3;
    public static final int GSM_NPI_TELEX = 4;
    public static final int GSM_NPI_NATIONAL = 8;
    public static final int GSM_NPI_PRIVATE = 9;
    public static final int GSM_NPI_ERMES = 10;
    public static final int GSM_NPI_RESERVED_EXTN = 15;
    private static Map errorTable = new Hashtable();

    private GSMConstants() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initTables() {
        Map map = errorTable;
        synchronized (map) {
            if (errorTable.size() > 0) {
                return;
            }
        }
        errorTable.put(new Integer(0), "No error");
        errorTable.put(new Integer(1), "Unknown Customer");
        errorTable.put(new Integer(11), "Not provisioned");
        errorTable.put(new Integer(13), "Call is barred");
        errorTable.put(new Integer(15), "CUG Rejected");
        errorTable.put(new Integer(19), "Sms not supported by MS");
        errorTable.put(new Integer(20), "Error in receiveing MS");
        errorTable.put(new Integer(21), "Facility not supported");
        errorTable.put(new Integer(22), "Memory capacity exceeded");
        errorTable.put(new Integer(29), "Absent Subscriber");
        errorTable.put(new Integer(30), "Absent Subscriber detached");
        errorTable.put(new Integer(31), "MS did not respond to 2 pages");
        errorTable.put(new Integer(32), "Subscriber roamed to new PLMN");
        errorTable.put(new Integer(36), "System failure");
    }

    public static String getGsmErr(int code) {
        GSMConstants.initTables();
        String s = (String)errorTable.get(new Integer(code));
        return s == null ? "" : s;
    }
}

