/*
 * Decompiled with CFR 0.152.
 */
package cucumber.formatter;

import cucumber.formatter.CucumberPrettyFormatter;
import cucumber.formatter.HTMLFormatter;
import cucumber.formatter.JUnitFormatter;
import cucumber.formatter.NullFormatter;
import cucumber.formatter.ProgressFormatter;
import cucumber.formatter.UsageFormatter;
import cucumber.runtime.CucumberException;
import gherkin.formatter.Formatter;
import gherkin.formatter.JSONFormatter;
import gherkin.formatter.JSONPrettyFormatter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormatterConverter {
    private Class[] CTOR_ARGS = new Class[]{Appendable.class, File.class};
    private static final Map<String, Class<? extends Formatter>> FORMATTER_CLASSES = new HashMap<String, Class<? extends Formatter>>(){
        {
            this.put("null", NullFormatter.class);
            this.put("junit", JUnitFormatter.class);
            this.put("html", HTMLFormatter.class);
            this.put("pretty", CucumberPrettyFormatter.class);
            this.put("progress", ProgressFormatter.class);
            this.put("json", JSONFormatter.class);
            this.put("json-pretty", JSONPrettyFormatter.class);
            this.put("usage", UsageFormatter.class);
        }
    };
    private static final Pattern FORMATTER_WITH_FILE_PATTERN = Pattern.compile("([^:]+):(.*)");
    private Appendable defaultOut = System.out;

    public Formatter convert(String formatterString) {
        Object ctorArg;
        String formatterName;
        Matcher formatterWithFile = FORMATTER_WITH_FILE_PATTERN.matcher(formatterString);
        if (formatterWithFile.matches()) {
            formatterName = formatterWithFile.group(1);
            ctorArg = new File(formatterWithFile.group(2));
        } else {
            formatterName = formatterString;
            ctorArg = this.defaultOutIfAvailable();
        }
        Class<? extends Formatter> formatterClass = this.formatterClass(formatterName);
        try {
            return this.instantiate(formatterString, formatterClass, ctorArg);
        }
        catch (IOException e) {
            throw new CucumberException(e);
        }
    }

    private Formatter instantiate(String formatterString, Class<? extends Formatter> formatterClass, Object ctorArg) throws IOException {
        for (Class ctorArgClass : this.CTOR_ARGS) {
            Constructor<? extends Formatter> constructor = this.findConstructor(formatterClass, ctorArgClass);
            if (constructor == null || (ctorArg = this.convertOrNull(ctorArg, ctorArgClass)) == null) continue;
            try {
                return constructor.newInstance(ctorArg);
            }
            catch (InstantiationException e) {
                throw new CucumberException(e);
            }
            catch (IllegalAccessException e) {
                throw new CucumberException(e);
            }
            catch (InvocationTargetException e) {
                throw new CucumberException(e.getTargetException());
            }
        }
        if (ctorArg == null) {
            throw new CucumberException(String.format("You must supply an output argument to %s. Like so: %s:output", formatterString, formatterString));
        }
        throw new CucumberException(String.format("%s must have a single-argument constructor that takes one of the following: %s", formatterClass, Arrays.asList(this.CTOR_ARGS)));
    }

    private Object convertOrNull(Object ctorArg, Class ctorArgClass) throws IOException {
        if (ctorArgClass.isAssignableFrom(ctorArg.getClass())) {
            return ctorArg;
        }
        if (ctorArgClass.equals(File.class) && ctorArg instanceof File) {
            return ctorArg;
        }
        if (ctorArgClass.equals(Appendable.class) && ctorArg instanceof File) {
            return new FileWriter((File)ctorArg);
        }
        return null;
    }

    private Constructor<? extends Formatter> findConstructor(Class<? extends Formatter> formatterClass, Class<?> ctorArgClass) {
        try {
            return formatterClass.getConstructor(ctorArgClass);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private Class<? extends Formatter> formatterClass(String formatterName) {
        Class<? extends Formatter> formatterClass = FORMATTER_CLASSES.get(formatterName);
        if (formatterClass == null) {
            formatterClass = this.loadClass(formatterName);
        }
        return formatterClass;
    }

    private Class<? extends Formatter> loadClass(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new CucumberException("Couldn't load formatter class: " + className, e);
        }
    }

    private Appendable defaultOutIfAvailable() {
        try {
            if (this.defaultOut != null) {
                Appendable appendable = this.defaultOut;
                return appendable;
            }
            throw new CucumberException("Only one formatter can use STDOUT. If you use more than one formatter you must specify output path with FORMAT:PATH");
        }
        finally {
            this.defaultOut = null;
        }
    }
}

