/*
 * Decompiled with CFR 0.152.
 */
package cucumber.io;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

public class FlatteningIterator
implements Iterator {
    private final Object blank = new Object();
    private final Stack<Iterator<?>> iterators = new Stack();
    private Object next = this.blank;

    public FlatteningIterator(Object ... objects) {
        Iterator<Object> iterator = Arrays.asList(objects).iterator();
        this.push(iterator);
    }

    public void push(Iterator<?> iterator) {
        this.iterators.push(iterator);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void moveToNext() {
        if (this.next == this.blank && !this.iterators.empty()) {
            if (!this.iterators.peek().hasNext()) {
                this.iterators.pop();
                this.moveToNext();
            } else {
                Object next = this.iterators.peek().next();
                if (next instanceof Iterator) {
                    this.push((Iterator)next);
                    this.moveToNext();
                } else if (next instanceof Iterable) {
                    this.push(((Iterable)next).iterator());
                    this.moveToNext();
                } else if (next instanceof Array) {
                    this.push(Arrays.asList((Array)next).iterator());
                    this.moveToNext();
                } else {
                    this.next = next;
                }
            }
        }
    }

    public Object next() {
        this.moveToNext();
        if (this.next == this.blank) {
            throw new NoSuchElementException();
        }
        Object next = this.next;
        this.next = this.blank;
        return next;
    }

    @Override
    public boolean hasNext() {
        this.moveToNext();
        return this.next != this.blank;
    }
}

