/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.model;

import cucumber.runtime.Runtime;
import cucumber.runtime.model.CucumberFeature;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.BasicStatement;
import gherkin.formatter.model.Step;
import java.util.ArrayList;
import java.util.List;

public class StepContainer {
    private final List<Step> steps = new ArrayList<Step>();
    protected final CucumberFeature cucumberFeature;
    private final BasicStatement statement;

    public StepContainer(CucumberFeature cucumberFeature, BasicStatement statement) {
        this.cucumberFeature = cucumberFeature;
        this.statement = statement;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void step(Step step) {
        this.steps.add(step);
    }

    protected void format(Formatter formatter) {
        this.statement.replay(formatter);
        for (Step step : this.getSteps()) {
            formatter.step(step);
        }
    }

    public void runSteps(Reporter reporter, Runtime runtime) {
        for (Step step : this.getSteps()) {
            this.runStep(step, reporter, runtime);
        }
    }

    public void runStep(Step step, Reporter reporter, Runtime runtime) {
        runtime.runStep(this.cucumberFeature.getUri(), step, reporter, this.cucumberFeature.getI18n());
    }
}

