/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.xstream.converters.extended;

import cucumber.runtime.xstream.converters.ConversionException;
import cucumber.runtime.xstream.converters.Converter;
import cucumber.runtime.xstream.converters.ConverterLookup;
import cucumber.runtime.xstream.converters.MarshallingContext;
import cucumber.runtime.xstream.converters.SingleValueConverter;
import cucumber.runtime.xstream.converters.UnmarshallingContext;
import cucumber.runtime.xstream.converters.reflection.AbstractReflectionConverter;
import cucumber.runtime.xstream.converters.reflection.ReflectionProvider;
import cucumber.runtime.xstream.core.util.FastField;
import cucumber.runtime.xstream.core.util.HierarchicalStreams;
import cucumber.runtime.xstream.core.util.Primitives;
import cucumber.runtime.xstream.io.HierarchicalStreamReader;
import cucumber.runtime.xstream.io.HierarchicalStreamWriter;
import cucumber.runtime.xstream.mapper.Mapper;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class ToAttributedValueConverter
implements Converter {
    private final Class type;
    private final Mapper mapper;
    private final ReflectionProvider reflectionProvider;
    private final ConverterLookup lookup;
    private final Field valueField;

    public ToAttributedValueConverter(Class type, Mapper mapper, ReflectionProvider reflectionProvider, ConverterLookup lookup, String valueFieldName) {
        this(type, mapper, reflectionProvider, lookup, valueFieldName, null);
    }

    public ToAttributedValueConverter(Class type, Mapper mapper, ReflectionProvider reflectionProvider, ConverterLookup lookup, String valueFieldName, Class valueDefinedIn) {
        this.type = type;
        this.mapper = mapper;
        this.reflectionProvider = reflectionProvider;
        this.lookup = lookup;
        if (valueFieldName == null) {
            this.valueField = null;
        } else {
            Field field = null;
            try {
                field = (valueDefinedIn != null ? valueDefinedIn : type).getDeclaredField(valueFieldName);
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException(e.getMessage() + ": " + valueFieldName);
            }
            this.valueField = field;
        }
    }

    public boolean canConvert(Class type) {
        return this.type == type;
    }

    public void marshal(Object source, final HierarchicalStreamWriter writer, final MarshallingContext context) {
        final Class<?> sourceType = source.getClass();
        final HashMap defaultFieldDefinition = new HashMap();
        final String[] tagValue = new String[1];
        final Object[] realValue = new Object[1];
        final Class[] fieldType = new Class[1];
        final Class[] definingType = new Class[1];
        this.reflectionProvider.visitSerializableFields(source, new ReflectionProvider.Visitor(){

            public void visit(String fieldName, Class type, Class definedIn, Object value) {
                if (!ToAttributedValueConverter.this.mapper.shouldSerializeMember(definedIn, fieldName)) {
                    return;
                }
                FastField field = new FastField(definedIn, fieldName);
                String alias = ToAttributedValueConverter.this.mapper.serializedMember(definedIn, fieldName);
                if (!defaultFieldDefinition.containsKey(alias)) {
                    Class lookupType = sourceType;
                    defaultFieldDefinition.put(alias, ToAttributedValueConverter.this.reflectionProvider.getField(lookupType, fieldName));
                } else if (!ToAttributedValueConverter.this.fieldIsEqual(field)) {
                    ConversionException exception = new ConversionException("Cannot write attribute twice for object");
                    exception.add("alias", alias);
                    exception.add("type", sourceType.getName());
                    throw exception;
                }
                Converter converter = ToAttributedValueConverter.this.mapper.getLocalConverter(definedIn, fieldName);
                if (converter == null) {
                    converter = ToAttributedValueConverter.this.lookup.lookupConverterForType(type);
                }
                if (value != null) {
                    if (converter instanceof SingleValueConverter) {
                        String str = ((SingleValueConverter)((Object)converter)).toString(value);
                        if (ToAttributedValueConverter.this.valueField != null && ToAttributedValueConverter.this.fieldIsEqual(field)) {
                            definingType[0] = definedIn;
                            fieldType[0] = type;
                            realValue[0] = value;
                            tagValue[0] = str;
                        } else if (str != null) {
                            writer.addAttribute(alias, str);
                        }
                    } else {
                        context.convertAnother(value);
                    }
                }
            }
        });
        if (tagValue[0] != null) {
            String attributeName;
            String serializedClassName;
            Class defaultType;
            Class<?> actualType = realValue[0].getClass();
            if (!actualType.equals(defaultType = this.mapper.defaultImplementationOf(fieldType[0])) && !(serializedClassName = this.mapper.serializedClass(actualType)).equals(this.mapper.serializedClass(defaultType)) && (attributeName = this.mapper.aliasForSystemAttribute("class")) != null) {
                writer.addAttribute(attributeName, serializedClassName);
            }
            writer.setValue(tagValue[0]);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ConversionException exception;
        String fieldName;
        Object result = this.reflectionProvider.newInstance(context.getRequiredType());
        Class<?> resultType = result.getClass();
        HashSet<FastField> seenFields = new HashSet<FastField>();
        Iterator it = reader.getAttributeNames();
        HashSet<String> systemAttributes = new HashSet<String>();
        systemAttributes.add(this.mapper.aliasForSystemAttribute("class"));
        while (it.hasNext()) {
            Field field;
            boolean fieldExistsInClass;
            String attrName = (String)it.next();
            if (systemAttributes.contains(attrName) || !(fieldExistsInClass = this.reflectionProvider.fieldDefinedInClass(fieldName = this.mapper.realMember(resultType, attrName), resultType)) || Modifier.isTransient((field = this.reflectionProvider.getField(resultType, fieldName)).getModifiers())) continue;
            Class type = field.getType();
            Class<?> declaringClass = field.getDeclaringClass();
            Converter converter = this.mapper.getLocalConverter(declaringClass, fieldName);
            if (converter == null) {
                converter = this.lookup.lookupConverterForType(type);
            }
            if (!(converter instanceof SingleValueConverter)) {
                exception = new ConversionException("Cannot read field as a single value for object");
                exception.add("field", fieldName);
                exception.add("type", resultType.getName());
                throw exception;
            }
            if (converter == null) continue;
            Object value = ((SingleValueConverter)((Object)converter)).fromString(reader.getAttribute(attrName));
            if (type.isPrimitive()) {
                type = Primitives.box(type);
            }
            if (value != null && !type.isAssignableFrom(value.getClass())) {
                ConversionException exception2 = new ConversionException("Cannot assign object to type");
                exception2.add("object type", value.getClass().getName());
                exception2.add("target type", type.getName());
                throw exception2;
            }
            this.reflectionProvider.writeField(result, fieldName, value, declaringClass);
            if (seenFields.add(new FastField(declaringClass, fieldName))) continue;
            throw new AbstractReflectionConverter.DuplicateFieldException(fieldName + " [" + declaringClass.getName() + "]");
        }
        if (this.valueField != null) {
            Class<?> classDefiningField = this.valueField.getDeclaringClass();
            fieldName = this.valueField.getName();
            if (fieldName == null || !this.reflectionProvider.fieldDefinedInClass(fieldName, resultType)) {
                ConversionException exception3 = new ConversionException("Cannot assign value to field of type");
                exception3.add("element", reader.getNodeName());
                exception3.add("field", fieldName);
                exception3.add("target type", context.getRequiredType().getName());
                throw exception3;
            }
            String classAttribute = HierarchicalStreams.readClassAttribute(reader, this.mapper);
            Class type = classAttribute != null ? this.mapper.realClass(classAttribute) : this.mapper.defaultImplementationOf(this.reflectionProvider.getFieldType(result, fieldName, classDefiningField));
            Field field = this.reflectionProvider.getField(classDefiningField, fieldName);
            Object value = context.convertAnother(result, type, this.mapper.getLocalConverter(field.getDeclaringClass(), field.getName()));
            Class definedType = this.reflectionProvider.getFieldType(result, fieldName, classDefiningField);
            if (!definedType.isPrimitive()) {
                type = definedType;
            }
            if (value != null && !type.isAssignableFrom(value.getClass())) {
                exception = new ConversionException("Cannot assign object to type");
                exception.add("object type", value.getClass().getName());
                exception.add("target type", type.getName());
                throw exception;
            }
            this.reflectionProvider.writeField(result, fieldName, value, classDefiningField);
            if (!seenFields.add(new FastField(classDefiningField, fieldName))) {
                throw new AbstractReflectionConverter.DuplicateFieldException(fieldName + " [" + classDefiningField.getName() + "]");
            }
        }
        return result;
    }

    private boolean fieldIsEqual(FastField field) {
        return this.valueField.getName().equals(field.getName()) && this.valueField.getDeclaringClass().getName().equals(field.getDeclaringClass());
    }
}

