/*
 * Decompiled with CFR 0.152.
 */
package cucumber.table;

import cucumber.table.TableConverter;
import cucumber.table.TableDiffer;
import gherkin.formatter.PrettyFormatter;
import gherkin.formatter.model.DataTableRow;
import gherkin.formatter.model.Row;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class DataTable {
    private final List<List<String>> raw;
    private final List<DataTableRow> gherkinRows;
    private final TableConverter tableConverter;

    public DataTable(List<DataTableRow> gherkinRows, TableConverter tableConverter) {
        this.gherkinRows = gherkinRows;
        this.tableConverter = tableConverter;
        this.raw = new ArrayList<List<String>>();
        for (DataTableRow row : gherkinRows) {
            ArrayList list = new ArrayList();
            list.addAll(row.getCells());
            this.raw.add(list);
        }
    }

    public List<List<String>> raw() {
        return this.raw;
    }

    public <T> List<T> asList(Type listType) {
        return this.tableConverter.toList(listType, this);
    }

    List<String> topCells() {
        return this.gherkinRows.get(0).getCells();
    }

    List<List<String>> cells(int firstRow) {
        ArrayList<List<String>> attributeValues = new ArrayList<List<String>>();
        List<DataTableRow> valueRows = this.gherkinRows.subList(firstRow, this.gherkinRows.size());
        for (DataTableRow valueRow : valueRows) {
            attributeValues.add(this.toStrings((Row)valueRow));
        }
        return attributeValues;
    }

    private List<String> toStrings(Row row) {
        ArrayList<String> strings = new ArrayList<String>();
        for (String string : row.getCells()) {
            strings.add(string);
        }
        return strings;
    }

    public void diff(List<List<String>> other) {
        this.diff(this.tableConverter.toTable(other));
    }

    private void diff(DataTable other) {
        new TableDiffer(this, other).calculateDiffs();
    }

    public List<DataTableRow> getGherkinRows() {
        return this.gherkinRows;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        PrettyFormatter pf = new PrettyFormatter((Appendable)result, true, false);
        pf.table(this.getGherkinRows());
        pf.eof();
        return result.toString();
    }

    List<DiffableRow> diffableRows() {
        ArrayList<DiffableRow> result = new ArrayList<DiffableRow>();
        List<List<String>> convertedRows = this.raw();
        for (int i = 0; i < convertedRows.size(); ++i) {
            result.add(new DiffableRow((Row)this.getGherkinRows().get(i), convertedRows.get(i)));
        }
        return result;
    }

    TableConverter getTableConverter() {
        return this.tableConverter;
    }

    class DiffableRow {
        public final Row row;
        public final List<String> convertedRow;

        public DiffableRow(Row row, List<String> convertedRow) {
            this.row = row;
            this.convertedRow = convertedRow;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DiffableRow that = (DiffableRow)o;
            return ((Object)this.convertedRow).equals(that.convertedRow);
        }

        public int hashCode() {
            return ((Object)this.convertedRow).hashCode();
        }
    }
}

