/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.api.Delimiter;
import cucumber.api.Format;
import cucumber.api.Transform;
import cucumber.api.Transformer;
import cucumber.api.Transpose;
import cucumber.deps.com.thoughtworks.xstream.annotations.XStreamConverter;
import cucumber.deps.com.thoughtworks.xstream.converters.SingleValueConverter;
import cucumber.runtime.CucumberException;
import cucumber.runtime.xstream.LocalizedXStreams;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class ParameterInfo {
    public static final String DEFAULT_DELIMITER = ",\\s?";
    private final Type type;
    private final String format;
    private final String delimiter;
    private final boolean transposed;
    private final Transformer<?> transformer;

    public static List<ParameterInfo> fromMethod(Method method) {
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < genericParameterTypes.length; ++i) {
            String format = null;
            String delimiter = DEFAULT_DELIMITER;
            boolean transposed = false;
            Transformer<?> transformer = null;
            for (Annotation annotation : annotations[i]) {
                if (annotation instanceof Format) {
                    format = ((Format)annotation).value();
                } else if (ParameterInfo.isAnnotatedWith(annotation, Format.class)) {
                    format = ParameterInfo.getAnnotationForAnnotation(annotation, Format.class).value();
                }
                if (annotation instanceof Delimiter) {
                    delimiter = ((Delimiter)annotation).value();
                } else if (ParameterInfo.isAnnotatedWith(annotation, Delimiter.class)) {
                    delimiter = ParameterInfo.getAnnotationForAnnotation(annotation, Delimiter.class).value();
                }
                if (annotation instanceof Transpose) {
                    transposed = ((Transpose)annotation).value();
                }
                if (annotation instanceof Transform) {
                    transformer = ParameterInfo.getTransformer(annotation);
                    continue;
                }
                if (!ParameterInfo.isAnnotatedWith(annotation, Transform.class)) continue;
                transformer = ParameterInfo.getTransformer(ParameterInfo.getAnnotationForAnnotation(annotation, Transform.class));
            }
            result.add(new ParameterInfo(genericParameterTypes[i], format, delimiter, transposed, transformer));
        }
        return result;
    }

    private static boolean isAnnotatedWith(Annotation source, Class<? extends Annotation> requiredAnnotation) {
        return ParameterInfo.getAnnotationForAnnotation(source, requiredAnnotation) != null;
    }

    private static <T extends Annotation> T getAnnotationForAnnotation(Annotation source, Class<T> requiredAnnotation) {
        return source.annotationType().getAnnotation(requiredAnnotation);
    }

    private static Transformer<?> getTransformer(Annotation annotation) {
        try {
            return ((Transform)annotation).value().newInstance();
        }
        catch (InstantiationException e) {
            throw new CucumberException(e);
        }
        catch (IllegalAccessException e) {
            throw new CucumberException(e);
        }
    }

    public ParameterInfo(Type type, String format, String delimiter, Transformer transformer) {
        this(type, format, delimiter, false, transformer);
    }

    public ParameterInfo(Type type, String format, String delimiter, boolean transposed, Transformer transformer) {
        this.type = type;
        this.format = format;
        this.delimiter = delimiter;
        this.transposed = transposed;
        this.transformer = transformer;
    }

    public Class<?> getRawType() {
        return this.getRawType(this.type);
    }

    private Class<?> getRawType(Type type) {
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return (Class)type;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isTransposed() {
        return this.transposed;
    }

    public String toString() {
        return this.type.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object convert(String value, LocalizedXStreams.LocalizedXStream xStream) {
        try {
            SingleValueConverter converter;
            xStream.setParameterInfo(this);
            xStream.processAnnotations(this.getRawType());
            xStream.autodetectAnnotations(true);
            if (this.transformer != null) {
                this.transformer.setParameterInfoAndLocale(this, xStream.getLocale());
                converter = this.transformer;
            } else {
                converter = List.class.isAssignableFrom(this.getRawType()) ? this.getListConverter(this.type, xStream) : this.getConverter(this.getRawType(), xStream);
                if (converter == null) {
                    throw new CucumberException(String.format("Don't know how to convert \"%s\" into %s.\nTry writing your own converter:\n\n@%s(%sConverter.class)\npublic class %s {}\n", value, this.getRawType().getName(), XStreamConverter.class.getName(), this.getRawType().getSimpleName(), this.getRawType().getSimpleName()));
                }
            }
            Object object = converter.fromString(value);
            return object;
        }
        finally {
            xStream.unsetParameterInfo();
        }
    }

    private SingleValueConverter getListConverter(Type type, LocalizedXStreams.LocalizedXStream xStream) {
        Class<Object> elementType = type instanceof ParameterizedType ? this.getRawType(((ParameterizedType)type).getActualTypeArguments()[0]) : Object.class;
        SingleValueConverter elementConverter = this.getConverter(elementType, xStream);
        if (elementConverter == null) {
            return null;
        }
        return xStream.createListConverter(this.delimiter, elementConverter);
    }

    private SingleValueConverter getConverter(Class<?> type, LocalizedXStreams.LocalizedXStream xStream) {
        if (type.isEnum()) {
            return xStream.createEnumConverter(type);
        }
        return xStream.getSingleValueConverter(type);
    }

    public String getFormat() {
        return this.format;
    }
}

