/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.io;

import cucumber.runtime.CucumberException;
import cucumber.runtime.io.Resource;
import cucumber.runtime.io.ResourceIteratorFactory;
import cucumber.runtime.io.ZipThenFileResourceIteratorFallback;
import java.net.URL;
import java.util.Iterator;
import java.util.ServiceLoader;

public class DelegatingResourceIteratorFactory
implements ResourceIteratorFactory {
    private final Iterable<ResourceIteratorFactory> delegates = ServiceLoader.load(ResourceIteratorFactory.class);
    private final ResourceIteratorFactory fallback;

    public DelegatingResourceIteratorFactory() {
        this(new ZipThenFileResourceIteratorFallback());
    }

    public DelegatingResourceIteratorFactory(ResourceIteratorFactory fallback) {
        this.fallback = fallback;
    }

    @Override
    public boolean isFactoryFor(URL url) {
        for (ResourceIteratorFactory delegate : this.delegates) {
            if (!delegate.isFactoryFor(url)) continue;
            return true;
        }
        return this.fallback.isFactoryFor(url);
    }

    @Override
    public Iterator<Resource> createIterator(URL url, String path, String suffix) {
        for (ResourceIteratorFactory delegate : this.delegates) {
            if (!delegate.isFactoryFor(url)) continue;
            return delegate.createIterator(url, path, suffix);
        }
        if (this.fallback.isFactoryFor(url)) {
            return this.fallback.createIterator(url, path, suffix);
        }
        throw new CucumberException("Fallback factory cannot handle URL: " + url);
    }
}

