/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.runtime.CucumberException;
import cucumber.runtime.Utils;
import cucumber.runtime.formatter.CucumberPrettyFormatter;
import cucumber.runtime.formatter.HTMLFormatter;
import cucumber.runtime.formatter.JUnitFormatter;
import cucumber.runtime.formatter.NullFormatter;
import cucumber.runtime.formatter.ProgressFormatter;
import cucumber.runtime.formatter.UsageFormatter;
import cucumber.runtime.io.URLOutputStream;
import cucumber.runtime.io.UTF8OutputStreamWriter;
import gherkin.formatter.Formatter;
import gherkin.formatter.JSONFormatter;
import gherkin.formatter.JSONPrettyFormatter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormatterFactory {
    private final Class[] CTOR_ARGS = new Class[]{null, Appendable.class, URL.class, File.class};
    private static final Map<String, Class<? extends Formatter>> FORMATTER_CLASSES = new HashMap<String, Class<? extends Formatter>>(){
        {
            this.put("null", NullFormatter.class);
            this.put("junit", JUnitFormatter.class);
            this.put("html", HTMLFormatter.class);
            this.put("pretty", CucumberPrettyFormatter.class);
            this.put("progress", ProgressFormatter.class);
            this.put("json", JSONFormatter.class);
            this.put("json-pretty", JSONPrettyFormatter.class);
            this.put("usage", UsageFormatter.class);
        }
    };
    private static final Pattern FORMATTER_WITH_FILE_PATTERN = Pattern.compile("([^:]+):(.*)");
    private Appendable defaultOut = new OutputStreamWriter(System.out){

        @Override
        public void close() throws IOException {
        }
    };

    public Formatter create(String formatterString) {
        String formatterName;
        Matcher formatterWithFile = FORMATTER_WITH_FILE_PATTERN.matcher(formatterString);
        String path = null;
        if (formatterWithFile.matches()) {
            formatterName = formatterWithFile.group(1);
            path = formatterWithFile.group(2);
        } else {
            formatterName = formatterString;
        }
        Class<? extends Formatter> formatterClass = this.formatterClass(formatterName);
        try {
            return this.instantiate(formatterString, formatterClass, path);
        }
        catch (IOException e) {
            throw new CucumberException(e);
        }
    }

    private Formatter instantiate(String formatterString, Class<? extends Formatter> formatterClass, String pathOrUrl) throws IOException {
        for (Class ctorArgClass : this.CTOR_ARGS) {
            Constructor<? extends Formatter> constructor = this.findConstructor(formatterClass, ctorArgClass);
            if (constructor == null) continue;
            Object ctorArg = this.convertOrNull(pathOrUrl, ctorArgClass);
            try {
                if (ctorArgClass == null) {
                    return constructor.newInstance(new Object[0]);
                }
                if (ctorArg == null) {
                    throw new CucumberException(String.format("You must supply an output argument to %s. Like so: %s:output", formatterString, formatterString));
                }
                return constructor.newInstance(ctorArg);
            }
            catch (InstantiationException e) {
                throw new CucumberException(e);
            }
            catch (IllegalAccessException e) {
                throw new CucumberException(e);
            }
            catch (InvocationTargetException e) {
                throw new CucumberException(e.getTargetException());
            }
        }
        throw new CucumberException(String.format("%s must have a constructor that is either empty or takes a %s or %s", formatterClass, Appendable.class.getName(), URL.class.getName()));
    }

    private Object convertOrNull(String pathOrUrl, Class ctorArgClass) throws IOException {
        if (ctorArgClass == null) {
            return null;
        }
        if (ctorArgClass.equals(URL.class) && pathOrUrl != null) {
            return Utils.toURL(pathOrUrl);
        }
        if (ctorArgClass.equals(File.class) && pathOrUrl != null) {
            return new File(pathOrUrl);
        }
        if (ctorArgClass.equals(Appendable.class)) {
            if (pathOrUrl != null) {
                return new UTF8OutputStreamWriter(new URLOutputStream(Utils.toURL(pathOrUrl)));
            }
            return this.defaultOutOrFailIfAlreadyUsed();
        }
        return null;
    }

    private Constructor<? extends Formatter> findConstructor(Class<? extends Formatter> formatterClass, Class<?> ctorArgClass) {
        try {
            if (ctorArgClass == null) {
                return formatterClass.getConstructor(new Class[0]);
            }
            return formatterClass.getConstructor(ctorArgClass);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private Class<? extends Formatter> formatterClass(String formatterName) {
        Class<? extends Formatter> formatterClass = FORMATTER_CLASSES.get(formatterName);
        if (formatterClass == null) {
            formatterClass = this.loadClass(formatterName);
        }
        return formatterClass;
    }

    private Class<? extends Formatter> loadClass(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new CucumberException("Couldn't load formatter class: " + className, e);
        }
    }

    private Appendable defaultOutOrFailIfAlreadyUsed() {
        try {
            if (this.defaultOut != null) {
                Appendable appendable = this.defaultOut;
                return appendable;
            }
            throw new CucumberException("Only one formatter can use STDOUT. If you use more than one formatter you must specify output path with FORMAT:PATH_OR_URL");
        }
        finally {
            this.defaultOut = null;
        }
    }
}

