/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java.picocontainer;

import cucumber.runtime.java.ObjectFactory;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Set;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoBuilder;

public class PicoFactory
implements ObjectFactory {
    private MutablePicoContainer pico;
    private final Set<Class<?>> classes = new HashSet();

    @Override
    public void start() {
        this.pico = new PicoBuilder().withCaching().build();
        for (Class<?> clazz : this.classes) {
            this.pico.addComponent(clazz);
        }
        this.pico.start();
    }

    @Override
    public void stop() {
        this.pico.stop();
        this.pico.dispose();
    }

    @Override
    public void addClass(Class<?> clazz) {
        if (this.classes.add(clazz)) {
            this.addConstructorDependencies(clazz);
        }
    }

    @Override
    public <T> T getInstance(Class<T> type) {
        return this.pico.getComponent(type);
    }

    private void addConstructorDependencies(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            for (Class<?> paramClazz : constructor.getParameterTypes()) {
                this.addClass(paramClazz);
            }
        }
    }
}

