/*
 * Decompiled with CFR 0.152.
 */
package gherkin.parser;

import gherkin.I18n;
import gherkin.formatter.Formatter;
import gherkin.lexer.I18nLexer;
import gherkin.lexer.Listener;
import gherkin.parser.FormatterListener;
import gherkin.parser.ParseError;
import gherkin.parser.StateMachineReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Parser
implements Listener {
    List<Machine> machines = new ArrayList<Machine>();
    private final boolean throwOnError;
    private final String machineName;
    private FormatterListener listener;
    private I18nLexer lexer;
    private String featureURI;
    private Integer lineOffset;
    private final Formatter formatter;

    public Parser(Formatter formatter) {
        this(formatter, true);
    }

    public Parser(Formatter formatter, boolean throwOnError) {
        this(formatter, throwOnError, "root");
    }

    public Parser(Formatter formatter, boolean throwOnError, String machineName) {
        this(formatter, throwOnError, machineName, false);
    }

    public Parser(Formatter formatter, boolean throwOnError, String machineName, boolean forceRubyDummy) {
        if (formatter == null) {
            throw new NullPointerException("formatter");
        }
        this.formatter = formatter;
        this.listener = new FormatterListener(formatter);
        this.throwOnError = throwOnError;
        this.machineName = machineName;
        this.lexer = new I18nLexer(this, forceRubyDummy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String gherkin, String featureURI, Integer lineOffset) {
        this.formatter.uri(featureURI);
        this.featureURI = featureURI;
        this.lineOffset = lineOffset;
        this.pushMachine(this.machineName);
        try {
            this.lexer.scan(gherkin);
        }
        finally {
            this.popMachine();
        }
    }

    public I18n getI18nLanguage() {
        return this.lexer.getI18nLanguage();
    }

    private void pushMachine(String machineName) {
        this.machines.add(new Machine(this, machineName, this.featureURI));
    }

    private void popMachine() {
        this.machines.remove(this.machines.size() - 1);
    }

    @Override
    public void tag(String tag, Integer line) {
        if (this.event("tag", line)) {
            this.listener.tag(tag, line);
        }
    }

    @Override
    public void docString(String contentType, String content, Integer line) {
        if (this.event("doc_string", line)) {
            this.listener.docString(contentType, content, line);
        }
    }

    @Override
    public void feature(String keyword, String name, String description, Integer line) {
        if (this.event("feature", line)) {
            this.listener.feature(keyword, name, description, line);
        }
    }

    @Override
    public void background(String keyword, String name, String description, Integer line) {
        if (this.event("background", line)) {
            this.listener.background(keyword, name, description, line);
        }
    }

    @Override
    public void scenario(String keyword, String name, String description, Integer line) {
        if (this.event("scenario", line)) {
            this.listener.scenario(keyword, name, description, line);
        }
    }

    @Override
    public void scenarioOutline(String keyword, String name, String description, Integer line) {
        if (this.event("scenario_outline", line)) {
            this.listener.scenarioOutline(keyword, name, description, line);
        }
    }

    @Override
    public void examples(String keyword, String name, String description, Integer line) {
        if (this.event("examples", line)) {
            this.listener.examples(keyword, name, description, line);
        }
    }

    @Override
    public void step(String keyword, String name, Integer line) {
        if (this.event("step", line)) {
            this.listener.step(keyword, name, line);
        }
    }

    @Override
    public void comment(String comment, Integer line) {
        if (this.event("comment", line)) {
            this.listener.comment(comment, line);
        }
    }

    @Override
    public void row(List<String> cells, Integer line) {
        if (this.event("row", line)) {
            this.listener.row(cells, line);
        }
    }

    @Override
    public void eof() {
        if (this.event("eof", 1)) {
            this.listener.eof();
        }
    }

    private boolean event(String event, Integer line) {
        try {
            this.machine().event(event, line);
            return true;
        }
        catch (ParseError e) {
            if (this.throwOnError) {
                throw e;
            }
            int l = this.lineOffset + line;
            this.listener.syntaxError(e.getState(), event, e.getLegalEvents(), this.featureURI, l);
            return false;
        }
    }

    private Machine machine() {
        return this.machines.get(this.machines.size() - 1);
    }

    private static class Machine {
        private static final Pattern PUSH = Pattern.compile("push\\((.+)\\)");
        private static final Map<String, Map<String, Map<String, String>>> TRANSITION_MAPS = new HashMap<String, Map<String, Map<String, String>>>();
        private final Parser parser;
        private final String name;
        private final String uri;
        private String state;
        private Map<String, Map<String, String>> transitionMap;

        public Machine(Parser parser, String name, String uri) {
            if (uri == null) {
                throw new NullPointerException("uri");
            }
            this.parser = parser;
            this.name = name;
            this.state = name;
            this.uri = uri;
            this.transitionMap = this.transitionMap(name);
        }

        public void event(String event, Integer line) {
            Map<String, String> states = this.transitionMap.get(this.state);
            if (states == null) {
                throw new RuntimeException("Unknown getState: " + this.state + " for machine " + this.name);
            }
            String newState = states.get(event);
            if (newState == null) {
                throw new RuntimeException("Unknown transition: " + event + " among " + states + " for machine " + this.name + " in getState " + this.state);
            }
            if ("E".equals(newState)) {
                throw new ParseError(this.state, event, this.expectedEvents(), this.uri, line);
            }
            Matcher push = PUSH.matcher(newState);
            if (push.matches()) {
                this.parser.pushMachine(push.group(1));
                this.parser.event(event, line);
            } else if ("pop()".equals(newState)) {
                this.parser.popMachine();
                this.parser.event(event, line);
            } else {
                this.state = newState;
            }
        }

        private List<String> expectedEvents() {
            ArrayList<String> result = new ArrayList<String>();
            for (String event : this.transitionMap.get(this.state).keySet()) {
                if (this.transitionMap.get(this.state).get(event).equals("E")) continue;
                result.add(event);
            }
            Collections.sort(result);
            result.remove("eof");
            return result;
        }

        private Map<String, Map<String, String>> transitionMap(String name) {
            Map<String, Map<String, String>> map = TRANSITION_MAPS.get(name);
            if (map == null) {
                map = this.buildTransitionMap(name);
                TRANSITION_MAPS.put(name, map);
            }
            return map;
        }

        private Map<String, Map<String, String>> buildTransitionMap(String name) {
            HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
            List<List<String>> transitionTable = new StateMachineReader(name).transitionTable();
            List<String> events = transitionTable.get(0).subList(1, transitionTable.get(0).size());
            for (List<String> actions : transitionTable.subList(1, transitionTable.size())) {
                HashMap<String, String> transitions = new HashMap<String, String>();
                int col = 1;
                for (String event : events) {
                    transitions.put(event, actions.get(col++));
                }
                String state = actions.get(0);
                result.put(state, transitions);
            }
            return result;
        }
    }
}

