/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.agent;

import info.informatica.doc.agent.DownloadListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceDownloader<C>
extends Thread {
    private URL url;
    protected C nativeContent = null;
    protected List<DownloadListener<C>> listeners = new LinkedList<DownloadListener<C>>();
    private boolean done = false;

    public ResourceDownloader(URL url) {
        this.url = url;
    }

    public URL getURL() {
        return this.url;
    }

    public void addImageListener(DownloadListener<C> listener) {
        if (this.done) {
            if (this.nativeContent == null) {
                listener.doFailedDownload();
            } else {
                listener.doContentDownloaded(this.nativeContent);
            }
        } else {
            this.listeners.add(listener);
        }
    }

    public boolean isDone() {
        return this.done;
    }

    @Override
    public void run() {
        try {
            InputStream is = this.openStream();
            this.readContent(is);
            is.close();
            this.done = true;
            this.notifyDownload();
        }
        catch (IOException e) {
            this.notifyFailure();
        }
        this.listeners.clear();
    }

    protected InputStream openStream() throws IOException {
        return this.getURL().openStream();
    }

    protected abstract void readContent(InputStream var1) throws IOException;

    protected void notifyDownload() {
        Iterator<DownloadListener<C>> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().doContentDownloaded(this.nativeContent);
        }
        this.nativeContent = null;
    }

    protected void notifyFailure() {
        Iterator<DownloadListener<C>> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().doFailedDownload();
        }
    }

    public C getNativeContent() {
        return this.nativeContent;
    }
}

