/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.pdf.itext;

import com.lowagie.text.BadElementException;
import info.informatica.doc.agent.ResourceDownloader;
import info.informatica.doc.dom4j.DOM4JUserAgent;
import info.informatica.doc.pdf.itext.PDFStyleDatabase;
import info.informatica.doc.pdf.itext.PDFXHTMLElementReplacer;
import info.informatica.doc.style.css.StyleDatabase;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;

public class PDFUserAgent
extends DOM4JUserAgent {
    private StyleDatabase styleDb;

    public PDFUserAgent() {
        this(new PDFStyleDatabase());
    }

    public PDFUserAgent(PDFStyleDatabase styleDb) {
        this.styleDb = styleDb;
        this.setElementReplacer("http://www.w3.org/1999/xhtml", new PDFXHTMLElementReplacer());
    }

    public StyleDatabase getStyleDatabase() {
        return this.styleDb;
    }

    public ResourceDownloader createDownloader(URL url) {
        return new PDFImageDownloader(url);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PDFImageDownloader
    extends ResourceDownloader<com.lowagie.text.Image> {
        public PDFImageDownloader(URL url) {
            super(url);
        }

        @Override
        protected void readContent(InputStream is) throws IOException {
            try {
                this.nativeContent = com.lowagie.text.Image.getInstance((Image)ImageIO.read(is), null, (boolean)false);
            }
            catch (BadElementException e) {
                throw new IOException(e.getLocalizedMessage());
            }
        }
    }
}

