/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import info.informatica.doc.style.css.AbstractStyleDatabase;
import info.informatica.doc.style.css.SACParserFactory;
import info.informatica.doc.style.css.StyleDatabase;
import info.informatica.doc.style.css.StyleDeclarationFactory;
import info.informatica.doc.style.css.dom.CSSStyleDeclarationRule;
import info.informatica.doc.style.css.dom.LexicalPropertyListener;
import info.informatica.doc.style.css.dom.PropertyDocumentHandler;
import info.informatica.doc.style.css.property.AbstractCSSPrimitiveValue;
import info.informatica.doc.style.css.property.AbstractCSSValue;
import info.informatica.doc.style.css.property.CSSNumberValue;
import info.informatica.doc.style.css.property.CSSShorthandValue;
import info.informatica.doc.style.css.property.PropertyDatabase;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSS2Properties;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class BaseCSSStyleDeclaration
implements CSSStyleDeclaration,
LexicalPropertyListener,
Cloneable {
    private CSSStyleDeclarationRule parentRule;
    private HashMap<String, CSSValue> propValue = null;
    private ArrayList<String> propertyList = null;
    private ArrayList<String> priorities = null;
    private StyleDeclarationDocumentHandler styleDeclarationDocumentHandler = null;
    private CSS2Properties css2properties = new CSS2PropertiesImpl();
    private StyleDatabase styleDb = null;
    static Logger log = Logger.getLogger((String)BaseCSSStyleDeclaration.class.getName());

    BaseCSSStyleDeclaration(CSSStyleDeclarationRule parentRule) {
        this.parentRule = parentRule;
        this.propValue = new HashMap();
        this.propertyList = new ArrayList();
        this.priorities = new ArrayList();
    }

    public BaseCSSStyleDeclaration() {
        this.parentRule = null;
        this.propValue = new HashMap();
        this.propertyList = new ArrayList();
        this.priorities = new ArrayList();
    }

    protected BaseCSSStyleDeclaration(BaseCSSStyleDeclaration copiedObject) {
        this.parentRule = (CSSStyleDeclarationRule)copiedObject.getParentRule();
        this.priorities = (ArrayList)copiedObject.priorities.clone();
        this.propertyList = (ArrayList)copiedObject.propertyList.clone();
        this.propValue = (HashMap)copiedObject.propValue.clone();
    }

    public String getCssText() {
        int sz = this.propertyList.size();
        StringBuilder sb = new StringBuilder(50 + sz * 10);
        int i = 0;
        while (i < sz) {
            String ptyname = this.propertyList.get(i);
            CSSValue cssVal = this.propValue.get(ptyname);
            if (!(cssVal instanceof AbstractCSSPrimitiveValue) || !((AbstractCSSPrimitiveValue)cssVal).isSubproperty()) {
                String prio = this.priorities.get(i);
                sb.append(ptyname).append(':').append(' ').append(this.propValue.get(ptyname).getCssText());
                if (prio != null && "important".equals(prio)) {
                    sb.append(" ! important");
                }
                sb.append(';').append(' ');
            }
            ++i;
        }
        return sb.toString();
    }

    public void setCssText(String cssText) throws DOMException {
        Parser parser = SACParserFactory.createSACParser();
        InputSource source = new InputSource();
        StringReader re = new StringReader(cssText);
        source.setCharacterStream((Reader)re);
        this.clear();
        StyleDeclarationDocumentHandler handler = this.getStyleDeclarationDocumentHandler();
        handler.setLexicalRuleListener(this);
        parser.setDocumentHandler((DocumentHandler)handler);
        try {
            parser.parseStyleDeclaration(source);
        }
        catch (CSSException e) {
            throw new DOMException(12, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMException(12, e.getMessage());
        }
    }

    public String getPropertyValue(String propertyName) {
        CSSValue value = this.getCSSValue(propertyName);
        if (value != null) {
            return value.getCssText();
        }
        return "";
    }

    public CSSValue getPropertyCSSValue(String propertyName) {
        if (PropertyDatabase.getInstance().isShorthand(propertyName)) {
            return null;
        }
        return this.getCSSValue(propertyName);
    }

    protected CSSValue getCSSValue(String propertyName) {
        return this.propValue.get(propertyName);
    }

    public synchronized String removeProperty(String propertyName) throws DOMException {
        int idx = this.propertyList.indexOf(propertyName);
        if (idx >= 0) {
            this.propertyList.remove(idx);
            this.priorities.remove(idx);
            return this.propValue.remove(propertyName).getCssText();
        }
        return "";
    }

    public String getPropertyPriority(String propertyName) {
        int idx = this.propertyList.indexOf(propertyName);
        if (idx < 0) {
            return "";
        }
        String prio = this.priorities.get(idx);
        if (prio != null) {
            return prio;
        }
        return "";
    }

    public synchronized void setProperty(String propertyName, LexicalUnit value, String priority) throws DOMException {
        if (PropertyDatabase.getInstance().isShorthand(propertyName)) {
            CSSShorthandValue shVal = new CSSShorthandValue();
            this.setProperty(propertyName, shVal, priority);
            String cssText = this.setSubproperties(propertyName, value, priority);
            shVal.setShorthandText(cssText);
        } else {
            CSSValue cssvalue = AbstractCSSValue.createCSSValue(value);
            this.setProperty(propertyName, cssvalue, priority);
        }
    }

    public void setProperty(String propertyName, String value, String priority) throws DOMException {
        Parser parser;
        try {
            parser = SACParserFactory.createSACParser();
        }
        catch (DOMException e) {
            throw new DOMException(7, e.getMessage());
        }
        InputSource source = new InputSource();
        StringReader re = new StringReader(value);
        source.setCharacterStream((Reader)re);
        LexicalUnit lunit = null;
        try {
            lunit = parser.parsePropertyValue(source);
        }
        catch (CSSException e) {
            throw new DOMException(12, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        this.setProperty(propertyName, lunit, priority);
    }

    void setProperty(String propertyName, CSSValue cssValue, String priority) {
        if (!this.propertyList.contains(propertyName)) {
            this.addProperty(propertyName, cssValue, priority);
        } else {
            int idx = this.propertyList.indexOf(propertyName);
            this.propertyList.remove(idx);
            this.priorities.remove(idx);
            this.addProperty(propertyName, cssValue, priority);
        }
    }

    private void addProperty(String propertyName, CSSValue cssValue, String priority) {
        this.propertyList.add(propertyName);
        this.priorities.add(priority);
        this.propValue.put(propertyName, cssValue);
    }

    public int getLength() {
        return this.propertyList.size();
    }

    public String item(int index) {
        if (index < 0 || index > this.propertyList.size()) {
            return "";
        }
        return this.propertyList.get(index);
    }

    void clear() {
        this.propValue.clear();
        this.propertyList.clear();
        this.priorities.clear();
    }

    public CSSRule getParentRule() {
        return this.parentRule;
    }

    public void addStyle(BaseCSSStyleDeclaration style) {
        Iterator<String> it = style.propertyList.iterator();
        int i = 0;
        while (it.hasNext()) {
            String propertyName = it.next();
            if (!this.propertyList.contains(propertyName)) {
                this.propertyList.add(propertyName);
                this.priorities.add(style.priorities.get(i));
            } else {
                if ("important".equals(this.priorities.get(i))) continue;
                this.priorities.set(i, style.priorities.get(i));
            }
            this.propValue.put(propertyName, style.propValue.get(propertyName));
        }
    }

    public StyleDatabase getStyleDatabase() {
        return this.styleDb;
    }

    public void setStyleDatabase(StyleDatabase styleDb) {
        this.styleDb = styleDb;
    }

    protected CSSValue defaultPropertyValue(String propertyName) {
        CSSValue defval = PropertyDatabase.getInstance().getInitialValue(propertyName);
        if (defval == null) {
            if (propertyName.equals("color")) {
                defval = this.getStyleDatabase().getInitialColor();
            } else if (propertyName.equals("font-family")) {
                defval = StyleDeclarationFactory.parseProperty(this.getStyleDatabase().getDefaultGenericFontFamily());
            } else if (propertyName.equals("text-align")) {
                String directionValue = this.getPropertyValue("direction");
                defval = directionValue.equals("rtl") ? StyleDeclarationFactory.parseProperty("right") : StyleDeclarationFactory.parseProperty("left");
            } else if (propertyName.equals("border-top-color")) {
                defval = this.getColor();
            } else if (propertyName.equals("border-right-color")) {
                defval = this.getColor();
            } else if (propertyName.equals("border-bottom-color")) {
                defval = this.getColor();
            } else if (propertyName.equals("border-left-color")) {
                defval = this.getColor();
            } else if (propertyName.equals("quotes")) {
                defval = StyleDeclarationFactory.parseProperty("\" \"");
            }
        }
        return defval;
    }

    public CSSPrimitiveValue getColor() {
        CSSPrimitiveValue color = (CSSPrimitiveValue)this.getCSSValue("color");
        if (color == null) {
            color = this.styleDb != null ? this.getStyleDatabase().getInitialColor() : AbstractStyleDatabase.DEFAULT_INITIAL_COLOR;
        }
        return color;
    }

    protected String setSubproperties(String propertyName, LexicalUnit value, String priority) throws DOMException {
        PropertyDatabase pdb = PropertyDatabase.getInstance();
        if (pdb.isShorthand(propertyName)) {
            ShorthandSetter setter = "font".equals(propertyName) ? new FontShorthandSetter() : ("margin".equals(propertyName) ? new BoxShorthandSetter(propertyName) : ("padding".equals(propertyName) ? new BoxShorthandSetter("padding") : ("border".equals(propertyName) ? new BorderShorthandSetter() : ("border-width".equals(propertyName) ? new BoxShorthandSetter("border-width") : ("border-style".equals(propertyName) ? new BoxShorthandSetter("border-style") : ("border-color".equals(propertyName) ? new BoxShorthandSetter("border-color") : ("border-top".equals(propertyName) ? new BorderSideShorthandSetter(propertyName, "top") : ("border-right".equals(propertyName) ? new BorderSideShorthandSetter(propertyName, "right") : ("border-bottom".equals(propertyName) ? new BorderSideShorthandSetter(propertyName, "bottom") : ("border-left".equals(propertyName) ? new BorderSideShorthandSetter(propertyName, "left") : new ShorthandSetter(propertyName)))))))))));
            setter.init(value, priority);
            setter.assignSubproperties();
            return setter.getCssText();
        }
        return null;
    }

    protected Object clone() throws CloneNotSupportedException {
        return new BaseCSSStyleDeclaration(this);
    }

    StyleDeclarationDocumentHandler getStyleDeclarationDocumentHandler() {
        if (this.styleDeclarationDocumentHandler == null) {
            this.styleDeclarationDocumentHandler = new StyleDeclarationDocumentHandler();
        }
        return this.styleDeclarationDocumentHandler;
    }

    public CSS2Properties getCSS2Properties() {
        return this.css2properties;
    }

    class BorderShorthandSetter
    extends ShorthandSetter {
        BorderShorthandSetter() {
            super("border");
        }

        protected boolean assignSubproperty(String subproperty) {
            if ("border-width".equals(subproperty)) {
                CSSValue cssValue = this.createCSSValue(this.currentValue);
                if (35 == this.currentValue.getLexicalUnitType() && this.testIdentifiers(subproperty) || cssValue instanceof CSSNumberValue) {
                    String[] subparray = this.getPropertyDatabase().getShorthandSubproperties(subproperty);
                    int i = 0;
                    while (i < subparray.length) {
                        this.setSubpropertyValue(subparray[i], cssValue);
                        ++i;
                    }
                    this.nextCurrentValue();
                    return true;
                }
            } else if ("border-style".equals(subproperty)) {
                if (35 == this.currentValue.getLexicalUnitType() && this.testIdentifiers(subproperty)) {
                    CSSValue cssValue = this.createCSSValue(this.currentValue);
                    String[] subparray = this.getPropertyDatabase().getShorthandSubproperties(subproperty);
                    int i = 0;
                    while (i < subparray.length) {
                        this.setSubpropertyValue(subparray[i], cssValue);
                        ++i;
                    }
                    this.nextCurrentValue();
                    return true;
                }
            } else if ("border-color".equals(subproperty) && this.testColor(subproperty)) {
                CSSValue cssValue = this.createCSSValue(this.currentValue);
                String[] subparray = this.getPropertyDatabase().getShorthandSubproperties(subproperty);
                int i = 0;
                while (i < subparray.length) {
                    this.setSubpropertyValue(subparray[i], cssValue);
                    ++i;
                }
                this.currentValue = null;
                return true;
            }
            return false;
        }
    }

    class BorderSideShorthandSetter
    extends ShorthandSetter {
        private String pnameWidth;
        private String pnameStyle;
        private String pnameColor;

        BorderSideShorthandSetter(String shorthandName, String side) {
            super(shorthandName);
            this.pnameWidth = "border-" + side + "-width";
            this.pnameStyle = "border-" + side + "-style";
            this.pnameColor = "border-" + side + "-color";
        }

        protected boolean assignSubproperty(String subproperty) {
            if (this.pnameWidth.equals(subproperty)) {
                CSSValue cssValue = this.createCSSValue(this.currentValue);
                if (35 == this.currentValue.getLexicalUnitType() && this.testIdentifiers("border-width") || cssValue instanceof CSSNumberValue) {
                    this.setSubpropertyValue(subproperty, cssValue);
                    this.nextCurrentValue();
                    return true;
                }
            } else if (this.pnameStyle.equals(subproperty)) {
                if (35 == this.currentValue.getLexicalUnitType() && this.testIdentifiers("border-style")) {
                    CSSValue cssValue = this.createCSSValue(this.currentValue);
                    this.setSubpropertyValue(subproperty, cssValue);
                    this.nextCurrentValue();
                    return true;
                }
            } else if (this.pnameColor.equals(subproperty) && this.testColor(subproperty)) {
                CSSValue cssValue = this.createCSSValue(this.currentValue);
                this.setSubpropertyValue(subproperty, cssValue);
                this.currentValue = null;
                return true;
            }
            return false;
        }
    }

    class BoxShorthandSetter
    extends ShorthandSetter {
        BoxShorthandSetter(String shorthand) {
            super(shorthand);
        }

        public void assignSubproperties() {
            String[] subparray = this.getPropertyDatabase().getShorthandSubproperties(this.getShorthandName());
            switch (this.getPropertyCount()) {
                case 1: {
                    CSSValue cssValue = this.createCSSValue(this.currentValue);
                    int i = 0;
                    while (i < subparray.length) {
                        this.setSubpropertyValue(subparray[i], cssValue);
                        ++i;
                    }
                    break;
                }
                case 2: {
                    CSSValue cssValue = this.createCSSValue(this.currentValue);
                    this.setSubpropertyValue(subparray[0], cssValue);
                    this.setSubpropertyValue(subparray[2], cssValue);
                    this.nextCurrentValue();
                    cssValue = this.createCSSValue(this.currentValue);
                    this.setSubpropertyValue(subparray[1], cssValue);
                    this.setSubpropertyValue(subparray[3], cssValue);
                    break;
                }
                case 3: {
                    CSSValue cssValue = this.createCSSValue(this.currentValue);
                    this.setSubpropertyValue(subparray[0], cssValue);
                    this.nextCurrentValue();
                    cssValue = this.createCSSValue(this.currentValue);
                    this.setSubpropertyValue(subparray[1], cssValue);
                    this.setSubpropertyValue(subparray[3], cssValue);
                    this.nextCurrentValue();
                    cssValue = this.createCSSValue(this.currentValue);
                    this.setSubpropertyValue(subparray[2], cssValue);
                    break;
                }
                case 4: {
                    int i = 0;
                    while (i < subparray.length) {
                        CSSValue cssValue = this.createCSSValue(this.currentValue);
                        this.setSubpropertyValue(subparray[i], cssValue);
                        this.nextCurrentValue();
                        ++i;
                    }
                    break;
                }
                default: {
                    log.error((Object)("Found " + Integer.toString(this.getPropertyCount()) + " values for '" + this.getShorthandName() + "' shorthand property"));
                }
            }
        }
    }

    class CSS2PropertiesImpl
    implements CSS2Properties {
        CSS2PropertiesImpl() {
        }

        public String getAzimuth() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("azimuth");
        }

        public void setAzimuth(String azimuth) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("azimuth").setCssText(azimuth);
        }

        public String getBackground() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("background");
        }

        public void setBackground(String background) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("background").setCssText(background);
        }

        public String getBackgroundAttachment() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("background-attachment");
        }

        public void setBackgroundAttachment(String backgroundAttachment) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("background-attachment").setCssText(backgroundAttachment);
        }

        public String getBackgroundColor() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("background-color");
        }

        public void setBackgroundColor(String backgroundColor) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("background-color").setCssText(backgroundColor);
        }

        public String getBackgroundImage() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("background-image");
        }

        public void setBackgroundImage(String backgroundImage) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("background-attachment").setCssText(backgroundImage);
        }

        public String getBackgroundPosition() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("background-position");
        }

        public void setBackgroundPosition(String backgroundPosition) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("background-position").setCssText(backgroundPosition);
        }

        public String getBackgroundRepeat() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("background-repeat");
        }

        public void setBackgroundRepeat(String backgroundRepeat) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("background-repeat").setCssText(backgroundRepeat);
        }

        public String getBorder() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border");
        }

        public void setBorder(String border) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border").setCssText(border);
        }

        public String getBorderCollapse() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-collapse");
        }

        public void setBorderCollapse(String borderCollapse) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-collapse").setCssText(borderCollapse);
        }

        public String getBorderColor() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-color");
        }

        public void setBorderColor(String borderColor) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-color").setCssText(borderColor);
        }

        public String getBorderSpacing() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-spacing");
        }

        public void setBorderSpacing(String borderSpacing) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-spacing").setCssText(borderSpacing);
        }

        public String getBorderStyle() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-style");
        }

        public void setBorderStyle(String borderStyle) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-style").setCssText(borderStyle);
        }

        public String getBorderTop() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-top");
        }

        public void setBorderTop(String borderTop) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-top").setCssText(borderTop);
        }

        public String getBorderRight() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-right");
        }

        public void setBorderRight(String borderRight) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-right").setCssText(borderRight);
        }

        public String getBorderBottom() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-bottom");
        }

        public void setBorderBottom(String borderBottom) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-bottom").setCssText(borderBottom);
        }

        public String getBorderLeft() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-left");
        }

        public void setBorderLeft(String borderLeft) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-left").setCssText(borderLeft);
        }

        public String getBorderTopColor() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-top-color");
        }

        public void setBorderTopColor(String borderTopColor) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-top-color").setCssText(borderTopColor);
        }

        public String getBorderRightColor() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-right-color");
        }

        public void setBorderRightColor(String borderRightColor) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-right-color").setCssText(borderRightColor);
        }

        public String getBorderBottomColor() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-bottom-color");
        }

        public void setBorderBottomColor(String borderBottomColor) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-bottom-color").setCssText(borderBottomColor);
        }

        public String getBorderLeftColor() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-left-color");
        }

        public void setBorderLeftColor(String borderLeftColor) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-left-color").setCssText(borderLeftColor);
        }

        public String getBorderTopStyle() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-top-style");
        }

        public void setBorderTopStyle(String borderTopStyle) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-top-style").setCssText(borderTopStyle);
        }

        public String getBorderRightStyle() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-right-style");
        }

        public void setBorderRightStyle(String borderRightStyle) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-right-style").setCssText(borderRightStyle);
        }

        public String getBorderBottomStyle() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-bottom-style");
        }

        public void setBorderBottomStyle(String borderBottomStyle) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-bottom-style").setCssText(borderBottomStyle);
        }

        public String getBorderLeftStyle() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-left-style");
        }

        public void setBorderLeftStyle(String borderLeftStyle) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-left-style").setCssText(borderLeftStyle);
        }

        public String getBorderTopWidth() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-top-width");
        }

        public void setBorderTopWidth(String borderTopWidth) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-top-width").setCssText(borderTopWidth);
        }

        public String getBorderRightWidth() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-right-width");
        }

        public void setBorderRightWidth(String borderRightWidth) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-right-width").setCssText(borderRightWidth);
        }

        public String getBorderBottomWidth() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-bottom-width");
        }

        public void setBorderBottomWidth(String borderBottomWidth) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-bottom-width").setCssText(borderBottomWidth);
        }

        public String getBorderLeftWidth() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-left-width");
        }

        public void setBorderLeftWidth(String borderLeftWidth) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-left-width").setCssText(borderLeftWidth);
        }

        public String getBorderWidth() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("border-width");
        }

        public void setBorderWidth(String borderWidth) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("border-width").setCssText(borderWidth);
        }

        public String getBottom() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("bottom");
        }

        public void setBottom(String bottom) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("bottom").setCssText(bottom);
        }

        public String getCaptionSide() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("caption-side");
        }

        public void setCaptionSide(String captionSide) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("caption-side").setCssText(captionSide);
        }

        public String getClear() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("clear");
        }

        public void setClear(String clear) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("clear").setCssText(clear);
        }

        public String getClip() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("clip");
        }

        public void setClip(String clip) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("clip").setCssText(clip);
        }

        public String getColor() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("color");
        }

        public void setColor(String color) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("color").setCssText(color);
        }

        public String getContent() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("content");
        }

        public void setContent(String content) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("content").setCssText(content);
        }

        public String getCounterIncrement() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("counter-increment");
        }

        public void setCounterIncrement(String counterIncrement) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("counter-increment").setCssText(counterIncrement);
        }

        public String getCounterReset() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("counter-reset");
        }

        public void setCounterReset(String counterReset) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("counter-reset").setCssText(counterReset);
        }

        public String getCue() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("cue");
        }

        public void setCue(String cue) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("cue").setCssText(cue);
        }

        public String getCueAfter() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("cue-after");
        }

        public void setCueAfter(String cueAfter) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("cue-after").setCssText(cueAfter);
        }

        public String getCueBefore() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("cue-before");
        }

        public void setCueBefore(String cueBefore) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("cue-before").setCssText(cueBefore);
        }

        public String getCursor() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("cursor");
        }

        public void setCursor(String cursor) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("cursor").setCssText(cursor);
        }

        public String getDirection() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("direction");
        }

        public void setDirection(String direction) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("direction").setCssText(direction);
        }

        public String getDisplay() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("display");
        }

        public void setDisplay(String display) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("display").setCssText(display);
        }

        public String getElevation() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("elevation");
        }

        public void setElevation(String elevation) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("elevation").setCssText(elevation);
        }

        public String getEmptyCells() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("empty-cells");
        }

        public void setEmptyCells(String emptyCells) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("empty-cells").setCssText(emptyCells);
        }

        public String getCssFloat() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("css-float");
        }

        public void setCssFloat(String cssFloat) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("css-float").setCssText(cssFloat);
        }

        public String getFont() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("font");
        }

        public void setFont(String font) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("font").setCssText(font);
        }

        public String getFontFamily() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("font-family");
        }

        public void setFontFamily(String fontFamily) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("font-family").setCssText(fontFamily);
        }

        public String getFontSize() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("font-size");
        }

        public void setFontSize(String fontSize) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("font-size").setCssText(fontSize);
        }

        public String getFontSizeAdjust() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("font-size-adjust");
        }

        public void setFontSizeAdjust(String fontSizeAdjust) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("font-size-adjust").setCssText(fontSizeAdjust);
        }

        public String getFontStretch() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("font-stretch");
        }

        public void setFontStretch(String fontStretch) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("font-stretch").setCssText(fontStretch);
        }

        public String getFontStyle() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("font-style");
        }

        public void setFontStyle(String fontStyle) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("font-style").setCssText(fontStyle);
        }

        public String getFontVariant() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("font-variant");
        }

        public void setFontVariant(String fontVariant) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("font-variant").setCssText(fontVariant);
        }

        public String getFontWeight() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("font-weight");
        }

        public void setFontWeight(String fontWeight) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("font-weight").setCssText(fontWeight);
        }

        public String getHeight() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("height");
        }

        public void setHeight(String height) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("height").setCssText(height);
        }

        public String getLeft() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("left");
        }

        public void setLeft(String left) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("left").setCssText(left);
        }

        public String getLetterSpacing() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("letter-spacing");
        }

        public void setLetterSpacing(String letterSpacing) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("letter-spacing").setCssText(letterSpacing);
        }

        public String getLineHeight() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("line-height");
        }

        public void setLineHeight(String lineHeight) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("line-height").setCssText(lineHeight);
        }

        public String getListStyle() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("list-style");
        }

        public void setListStyle(String listStyle) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("list-style").setCssText(listStyle);
        }

        public String getListStyleImage() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("list-style-image");
        }

        public void setListStyleImage(String listStyleImage) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("list-style-image").setCssText(listStyleImage);
        }

        public String getListStylePosition() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("list-style-position");
        }

        public void setListStylePosition(String listStylePosition) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("list-style-position").setCssText(listStylePosition);
        }

        public String getListStyleType() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("list-style-type");
        }

        public void setListStyleType(String listStyleType) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("list-style-type").setCssText(listStyleType);
        }

        public String getMargin() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("margin");
        }

        public void setMargin(String margin) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("margin").setCssText(margin);
        }

        public String getMarginTop() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("margin-top");
        }

        public void setMarginTop(String marginTop) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("margin-top").setCssText(marginTop);
        }

        public String getMarginRight() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("margin-right");
        }

        public void setMarginRight(String marginRight) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("margin-right").setCssText(marginRight);
        }

        public String getMarginBottom() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("margin-bottom");
        }

        public void setMarginBottom(String marginBottom) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("margin-bottom").setCssText(marginBottom);
        }

        public String getMarginLeft() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("margin-left");
        }

        public void setMarginLeft(String marginLeft) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("margin-left").setCssText(marginLeft);
        }

        public String getMarkerOffset() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("marker-offset");
        }

        public void setMarkerOffset(String markerOffset) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("marker-offset").setCssText(markerOffset);
        }

        public String getMarks() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("marks");
        }

        public void setMarks(String marks) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("marks").setCssText(marks);
        }

        public String getMaxHeight() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("max-height");
        }

        public void setMaxHeight(String maxHeight) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("max-height").setCssText(maxHeight);
        }

        public String getMaxWidth() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("max-width");
        }

        public void setMaxWidth(String maxWidth) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("max-width").setCssText(maxWidth);
        }

        public String getMinHeight() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("min-height");
        }

        public void setMinHeight(String minHeight) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("min-height").setCssText(minHeight);
        }

        public String getMinWidth() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("min-width");
        }

        public void setMinWidth(String minWidth) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("min-width").setCssText(minWidth);
        }

        public String getOrphans() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("orphans");
        }

        public void setOrphans(String orphans) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("orphans").setCssText(orphans);
        }

        public String getOutline() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("outline");
        }

        public void setOutline(String outline) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("outline").setCssText(outline);
        }

        public String getOutlineColor() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("outline-color");
        }

        public void setOutlineColor(String outlineColor) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("outline-color").setCssText(outlineColor);
        }

        public String getOutlineStyle() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("outline-style");
        }

        public void setOutlineStyle(String outlineStyle) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("outline-style").setCssText(outlineStyle);
        }

        public String getOutlineWidth() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("outline-width");
        }

        public void setOutlineWidth(String outlineWidth) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("outline-width").setCssText(outlineWidth);
        }

        public String getOverflow() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("overflow");
        }

        public void setOverflow(String overflow) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("overflow").setCssText(overflow);
        }

        public String getPadding() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("padding");
        }

        public void setPadding(String padding) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("padding").setCssText(padding);
        }

        public String getPaddingTop() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("padding-top");
        }

        public void setPaddingTop(String paddingTop) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("padding-top").setCssText(paddingTop);
        }

        public String getPaddingRight() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("padding-right");
        }

        public void setPaddingRight(String paddingRight) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("padding-right").setCssText(paddingRight);
        }

        public String getPaddingBottom() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("padding-bottom");
        }

        public void setPaddingBottom(String paddingBottom) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("padding-bottom").setCssText(paddingBottom);
        }

        public String getPaddingLeft() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("padding-left");
        }

        public void setPaddingLeft(String paddingLeft) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("padding-left").setCssText(paddingLeft);
        }

        public String getPage() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("page");
        }

        public void setPage(String page) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("page").setCssText(page);
        }

        public String getPageBreakAfter() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("page-break-after");
        }

        public void setPageBreakAfter(String pageBreakAfter) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("page-break-after").setCssText(pageBreakAfter);
        }

        public String getPageBreakBefore() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("page-break-before");
        }

        public void setPageBreakBefore(String pageBreakBefore) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("page-break-before").setCssText(pageBreakBefore);
        }

        public String getPageBreakInside() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("page-break-inside");
        }

        public void setPageBreakInside(String pageBreakInside) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("page-break-inside").setCssText(pageBreakInside);
        }

        public String getPause() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("pause");
        }

        public void setPause(String pause) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("pause").setCssText(pause);
        }

        public String getPauseAfter() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("pause-after");
        }

        public void setPauseAfter(String pauseAfter) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("pause-after").setCssText(pauseAfter);
        }

        public String getPauseBefore() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("pause-before");
        }

        public void setPauseBefore(String pauseBefore) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("pause-before").setCssText(pauseBefore);
        }

        public String getPitch() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("pitch");
        }

        public void setPitch(String pitch) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("pitch").setCssText(pitch);
        }

        public String getPitchRange() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("pitch-range");
        }

        public void setPitchRange(String pitchRange) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("pitch-range").setCssText(pitchRange);
        }

        public String getPlayDuring() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("play-during");
        }

        public void setPlayDuring(String playDuring) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("play-during").setCssText(playDuring);
        }

        public String getPosition() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("position");
        }

        public void setPosition(String position) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("position").setCssText(position);
        }

        public String getQuotes() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("quotes");
        }

        public void setQuotes(String quotes) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("quotes").setCssText(quotes);
        }

        public String getRichness() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("richness");
        }

        public void setRichness(String richness) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("richness").setCssText(richness);
        }

        public String getRight() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("right");
        }

        public void setRight(String right) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("right").setCssText(right);
        }

        public String getSize() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("size");
        }

        public void setSize(String size) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("size").setCssText(size);
        }

        public String getSpeak() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("speak");
        }

        public void setSpeak(String speak) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("speak").setCssText(speak);
        }

        public String getSpeakHeader() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("speak-header");
        }

        public void setSpeakHeader(String speakHeader) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("speak-header").setCssText(speakHeader);
        }

        public String getSpeakNumeral() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("speak-numeral");
        }

        public void setSpeakNumeral(String speakNumeral) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("speak-numeral").setCssText(speakNumeral);
        }

        public String getSpeakPunctuation() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("speak-punctuation");
        }

        public void setSpeakPunctuation(String speakPunctuation) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("speak-punctuation").setCssText(speakPunctuation);
        }

        public String getSpeechRate() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("speech-rate");
        }

        public void setSpeechRate(String speechRate) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("speech-rate").setCssText(speechRate);
        }

        public String getStress() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("stress");
        }

        public void setStress(String stress) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("stress").setCssText(stress);
        }

        public String getTableLayout() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("table-layout");
        }

        public void setTableLayout(String tableLayout) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("table-layout").setCssText(tableLayout);
        }

        public String getTextAlign() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("text-align");
        }

        public void setTextAlign(String textAlign) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("text-align").setCssText(textAlign);
        }

        public String getTextDecoration() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("text-decoration");
        }

        public void setTextDecoration(String textDecoration) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("text-decoration").setCssText(textDecoration);
        }

        public String getTextIndent() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("text-indent");
        }

        public void setTextIndent(String textIndent) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("text-indent").setCssText(textIndent);
        }

        public String getTextShadow() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("text-shadow");
        }

        public void setTextShadow(String textShadow) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("text-shadow").setCssText(textShadow);
        }

        public String getTextTransform() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("text-transform");
        }

        public void setTextTransform(String textTransform) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("text-transform").setCssText(textTransform);
        }

        public String getTop() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("top");
        }

        public void setTop(String top) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("top").setCssText(top);
        }

        public String getUnicodeBidi() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("unicode-bidi");
        }

        public void setUnicodeBidi(String unicodeBidi) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("unicode-bidi").setCssText(unicodeBidi);
        }

        public String getVerticalAlign() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("vertical-align");
        }

        public void setVerticalAlign(String verticalAlign) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("vertical-align").setCssText(verticalAlign);
        }

        public String getVisibility() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("visibility");
        }

        public void setVisibility(String visibility) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("visibility").setCssText(visibility);
        }

        public String getVoiceFamily() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("voice-family");
        }

        public void setVoiceFamily(String voiceFamily) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("voice-family").setCssText(voiceFamily);
        }

        public String getVolume() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("volume");
        }

        public void setVolume(String volume) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("volume").setCssText(volume);
        }

        public String getWhiteSpace() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("white-space");
        }

        public void setWhiteSpace(String whiteSpace) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("white-space").setCssText(whiteSpace);
        }

        public String getWidows() {
            return null;
        }

        public void setWidows(String widows) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("widows").setCssText(widows);
        }

        public String getWidth() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("width");
        }

        public void setWidth(String width) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("width").setCssText(width);
        }

        public String getWordSpacing() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("word-spacing");
        }

        public void setWordSpacing(String wordSpacing) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("word-spacing").setCssText(wordSpacing);
        }

        public String getZIndex() {
            return BaseCSSStyleDeclaration.this.getPropertyValue("z-index");
        }

        public void setZIndex(String zIndex) throws DOMException {
            BaseCSSStyleDeclaration.this.getPropertyCSSValue("z-index").setCssText(zIndex);
        }
    }

    class FontShorthandSetter
    extends ShorthandSetter {
        private LexicalUnit nextLex;

        FontShorthandSetter() {
            super("font");
            this.nextLex = null;
        }

        protected void nextCurrentValue() {
            super.nextCurrentValue();
            this.nextLex = this.currentValue != null ? this.currentValue.getNextLexicalUnit() : null;
        }

        protected boolean assignSubproperty(String subproperty) {
            if (subproperty.equals("font-size") && this.assignFontSize()) {
                if (this.currentValue != null && this.currentValue.getLexicalUnitType() == 4) {
                    this.nextCurrentValue();
                    CSSValue cssValue = this.createCSSValue(this.currentValue);
                    BaseCSSStyleDeclaration.this.setProperty("line-height", cssValue, this.getPriority());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Assigning shorthand subproperty line-height: " + cssValue.getCssText()));
                    }
                }
                this.nextCurrentValue();
                return true;
            }
            switch (this.currentValue.getLexicalUnitType()) {
                case 35: {
                    if (super.assignSubproperty(subproperty)) {
                        return true;
                    }
                    if (!subproperty.equals("font-family") || this.nextLex != null && this.nextLex.getLexicalUnitType() != 0) break;
                    CSSValue cssValue = this.createCSSValue(this.currentValue);
                    this.setSubpropertyValue(subproperty, cssValue);
                    this.currentValue = null;
                    this.nextLex = null;
                    return true;
                }
            }
            return false;
        }

        protected boolean assignFontSize() {
            if (this.currentValue.getLexicalUnitType() == 35) {
                return super.assignSubproperty("font-size");
            }
            CSSValue cssValue = this.createCSSValue(this.currentValue);
            if (cssValue instanceof CSSNumberValue) {
                this.setSubpropertyValue("font-size", cssValue);
                this.nextCurrentValue();
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ShorthandSetter {
        private String shorthandName;
        private String priority = null;
        private PropertyDatabase pdb = PropertyDatabase.getInstance();
        protected LexicalUnit currentValue = null;
        private short valueCount = 0;
        private short propertyCount = 0;
        protected short lookupCount = 0;
        private StringBuilder valueBuffer = new StringBuilder(32);
        private List<String> unassignedProperties = new ArrayList<String>(6);
        private List<LexicalUnit> unassignedValues = new ArrayList<LexicalUnit>(8);

        ShorthandSetter(String shorthandName) {
            this.shorthandName = shorthandName;
        }

        public String getShorthandName() {
            return this.shorthandName;
        }

        public String getPriority() {
            return this.priority;
        }

        public final PropertyDatabase getPropertyDatabase() {
            return this.pdb;
        }

        public short getValueCount() {
            return this.valueCount;
        }

        public short getPropertyCount() {
            return this.propertyCount;
        }

        protected void addUnassignedProperty(String propertyName) {
            this.unassignedProperties.add(propertyName);
            int sz = this.unassignedValues.size();
            if (sz > 0 && !this.unassignedValues.get(sz - 1).equals(this.currentValue)) {
                this.unassignedValues.add(this.currentValue);
            }
        }

        protected List<String> getUnassignedProperties() {
            return this.unassignedProperties;
        }

        protected void nextCurrentValue() {
            if (this.currentValue != null) {
                this.currentValue = this.currentValue.getNextLexicalUnit();
                if (this.currentValue != null && this.currentValue.getLexicalUnitType() == 0) {
                    this.currentValue = this.currentValue.getNextLexicalUnit();
                }
                this.appendValueString();
            }
        }

        public void init(LexicalUnit shorthandValue, String priority) {
            this.currentValue = shorthandValue;
            this.priority = priority;
            this.unassignedValues.clear();
            this.valueCount = 0;
            this.propertyCount = 0;
            this.valueBuffer.setLength(0);
            this.appendValueString();
            LexicalUnit value = shorthandValue;
            while (value != null) {
                this.valueCount = (short)(this.valueCount + 1);
                this.propertyCount = value.getLexicalUnitType() != 0 ? (short)(this.propertyCount + 1) : (short)(this.propertyCount - 1);
                value = value.getNextLexicalUnit();
            }
        }

        protected void resetSubproperties() {
            List<String> props = this.getUnassignedProperties();
            for (String pname : props) {
                if (!this.getPropertyDatabase().isShorthand(pname)) {
                    this.setPropertyDefault(pname);
                    continue;
                }
                String[] sh = this.getPropertyDatabase().getShorthandSubproperties(pname);
                int i = 0;
                while (i < sh.length) {
                    this.setPropertyDefault(sh[i]);
                    ++i;
                }
            }
        }

        private void setPropertyDefault(String pname) {
            CSSValue cssVal = BaseCSSStyleDeclaration.this.defaultPropertyValue(pname);
            if (cssVal != null) {
                ((AbstractCSSPrimitiveValue)cssVal).setSubproperty(true);
                BaseCSSStyleDeclaration.this.setProperty(pname, cssVal, this.getPriority());
            } else {
                log.info((Object)("No default for property " + pname));
            }
        }

        public void assignSubproperties() {
            String[] subparray = this.getPropertyDatabase().getShorthandSubproperties(this.getShorthandName());
            ArrayList subp = new ArrayList(subparray.length);
            subp.addAll(Arrays.asList((String[])subparray.clone()));
            block0: while (this.currentValue != null && this.lookupCount <= this.getValueCount()) {
                this.unassignedProperties.clear();
                int i = 0;
                while (i < subp.size()) {
                    String pname = (String)subp.get(i);
                    if (this.currentValue == null) continue block0;
                    if (!this.assignSubproperty(pname)) {
                        this.addUnassignedProperty(pname);
                    } else {
                        subp.remove(i);
                        --i;
                    }
                    this.lookupCount = (short)(this.lookupCount + 1);
                    ++i;
                }
            }
            this.resetSubproperties();
        }

        protected boolean assignSubproperty(String subproperty) {
            return 35 == this.currentValue.getLexicalUnitType() && this.assignIdentifiers(subproperty);
        }

        protected boolean assignIdentifiers(String subproperty) {
            if (this.testIdentifiers(subproperty)) {
                CSSValue cssValue = this.createCSSValue(this.currentValue);
                this.setSubpropertyValue(subproperty, cssValue);
                this.nextCurrentValue();
                return true;
            }
            return false;
        }

        protected boolean testIdentifiers(String subproperty) {
            return this.getPropertyDatabase().isIdentifierValue(subproperty, this.currentValue.getStringValue());
        }

        protected void setSubpropertyValue(String subproperty, CSSValue cssValue) {
            int szm1;
            BaseCSSStyleDeclaration.this.setProperty(subproperty, cssValue, this.getPriority());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Assigning shorthand subproperty " + subproperty + ": " + cssValue.getCssText()));
            }
            if ((szm1 = this.unassignedValues.size() - 1) >= 0) {
                if (this.unassignedValues.get(szm1).equals(this.currentValue)) {
                    this.unassignedValues.remove(szm1);
                    --szm1;
                }
                if (szm1 >= 0) {
                    StringBuilder sb = new StringBuilder(64);
                    sb.append("Unable to assign properties: ");
                    Iterator<String> it = this.unassignedProperties.iterator();
                    while (it.hasNext()) {
                        sb.append(' ').append(it.next());
                    }
                    log.warn((Object)sb.toString());
                }
            }
        }

        public CSSValue createCSSValue(LexicalUnit lunit) {
            return AbstractCSSValue.createCSSValue(this.currentValue, true);
        }

        protected void appendValueString() {
            CSSValue currentCss;
            if (this.currentValue != null && (currentCss = this.createCSSValue(this.currentValue)) != null) {
                String cssText = currentCss.getCssText();
                if (this.valueBuffer.length() > 0) {
                    this.valueBuffer.append(' ');
                }
                this.valueBuffer.append(cssText);
            }
        }

        public String getCssText() {
            return this.valueBuffer.toString();
        }

        protected boolean testColor(String subproperty) {
            if (35 == this.currentValue.getLexicalUnitType()) {
                return this.getPropertyDatabase().isIdentifierValue(subproperty, this.currentValue.getStringValue());
            }
            if (27 == this.currentValue.getLexicalUnitType()) {
                return true;
            }
            return 36 == this.currentValue.getLexicalUnitType() && this.currentValue.getStringValue().charAt(0) == '#';
        }
    }

    public class StyleDeclarationDocumentHandler
    extends PropertyDocumentHandler {
        public void startSelector(SelectorList selectors) throws CSSException {
            BaseCSSStyleDeclaration.this.parentRule.setSelectorList(selectors);
        }

        public void endSelector(SelectorList selectors) throws CSSException {
        }
    }
}

