/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import info.informatica.doc.style.css.CSSStyleSheetFactory;
import info.informatica.doc.style.css.SACParserFactory;
import info.informatica.doc.style.css.dom.BaseCSSStyleDeclaration;
import info.informatica.doc.style.css.dom.CSSRuleArrayList;
import info.informatica.doc.style.css.dom.CSSStyleDeclarationRule;
import info.informatica.doc.style.css.dom.ComputedCSSStyle;
import info.informatica.doc.style.css.dom.DOMCSSFontFaceRule;
import info.informatica.doc.style.css.dom.DOMCSSImportRule;
import info.informatica.doc.style.css.dom.DOMCSSMediaRule;
import info.informatica.doc.style.css.dom.DOMCSSPageRule;
import info.informatica.doc.style.css.dom.DOMCSSStyleRule;
import info.informatica.doc.style.css.dom.DOMMediaList;
import info.informatica.doc.style.css.dom.SelectorMatcher;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSMediaRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;
import org.w3c.dom.stylesheets.StyleSheet;

public class BaseCSSStyleSheet
implements CSSStyleSheet {
    private CSSStyleSheetFactory styleSheetFactory;
    private String namespaceUri = null;
    private StyleSheet parent = null;
    private String href = null;
    private String advisoryTitle = null;
    private CSSRule ownerRule = null;
    protected CSSRuleArrayList cssRules = new CSSRuleArrayList();
    protected int currentInsertionIndex = 0;
    private DOMMediaList targetMedia = null;
    private boolean disabled = false;
    static Logger log = Logger.getLogger((String)BaseCSSStyleSheet.class.getName());

    protected BaseCSSStyleSheet(CSSStyleSheetFactory factory, DOMMediaList media, CSSRule ownerRule) {
        this.targetMedia = media;
        this.ownerRule = ownerRule;
        this.styleSheetFactory = factory;
    }

    protected BaseCSSStyleSheet(CSSStyleSheetFactory factory, DOMMediaList media) {
        this(factory, media, null);
    }

    public CSSStyleSheetFactory getStyleSheetFactory() {
        return this.styleSheetFactory;
    }

    public CSSRule getOwnerRule() {
        return this.ownerRule;
    }

    public Node getOwnerNode() {
        return null;
    }

    public CSSRuleList getCssRules() {
        return this.cssRules;
    }

    public int insertRule(String rule, int index) throws DOMException {
        if (index > this.getCssRules().getLength() || index < 0) {
            throw new DOMException(1, "Invalid index: " + index);
        }
        Parser psr = SACParserFactory.createSACParser();
        InputSource source = new InputSource();
        StringReader re = new StringReader(rule);
        source.setCharacterStream((Reader)re);
        psr.setDocumentHandler(this.createDocumentHandler());
        this.currentInsertionIndex = index - 1;
        try {
            psr.parseRule(source);
        }
        catch (CSSException e) {
            throw new DOMException(12, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return this.currentInsertionIndex;
    }

    void addRule(CSSRule cssrule) {
        this.currentInsertionIndex = this.cssRules.insertRule(cssrule, ++this.currentInsertionIndex);
    }

    public void deleteRule(int index) throws DOMException {
        try {
            this.cssRules.remove(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DOMException(1, e.getMessage());
        }
    }

    public String getType() {
        return "text/css";
    }

    public String getNamespaceURI() {
        return this.namespaceUri;
    }

    public void setNamespaceURI(String uri) {
        this.namespaceUri = uri;
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public StyleSheet getParentStyleSheet() {
        return this.parent;
    }

    public void setParentStyleSheet(StyleSheet parent) {
        this.parent = parent;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public URL getDocumentBaseURL() {
        return null;
    }

    public String getTitle() {
        return this.advisoryTitle;
    }

    public void setTitle(String title) {
        this.advisoryTitle = title;
    }

    public MediaList getMedia() {
        return this.targetMedia;
    }

    DocumentHandler createDocumentHandler() {
        return new CSSDocumentHandler();
    }

    public String toString() {
        return this.getCssRules().toString();
    }

    /*
     * Unable to fully structure code
     */
    protected ComputedCSSStyle computeStyle(ComputedCSSStyle style, SelectorMatcher matcher, ComputedCSSStyle inlineStyle, String pseudoElt) {
        matcher.setPseudoElement(pseudoElt);
        matchingStyles = new TreeSet<DOMCSSStyleRule.Specifity>(new DOMCSSStyleRule.SpecificityComparator());
        for (CSSRule rule : this.cssRules) {
            if (!(rule instanceof DOMCSSStyleRule)) {
                BaseCSSStyleSheet.log.info((Object)("While computing style, found rule of type " + rule.getType()));
                continue;
            }
            stylerule = (DOMCSSStyleRule)rule;
            i = matcher.match(stylerule.getSelectorList());
            if (i < 0) continue;
            matchingStyles.add(stylerule.getSpecifity(i));
        }
        styleit = matchingStyles.iterator();
        if (styleit.hasNext()) ** GOTO lbl21
        if (BaseCSSStyleSheet.log.isDebugEnabled()) {
            BaseCSSStyleSheet.log.debug((Object)("Could not find styles matching selector " + matcher.toString()));
        }
        if (inlineStyle != null) {
            return inlineStyle;
        }
        return style;
lbl-1000:
        // 1 sources

        {
            style.addStyle((BaseCSSStyleDeclaration)((DOMCSSStyleRule.Specifity)styleit.next()).getCSSStyleRule().getStyle());
lbl21:
            // 2 sources

            ** while (styleit.hasNext())
        }
lbl22:
        // 1 sources

        if (inlineStyle != null) {
            style.addStyle(inlineStyle);
        }
        return style;
    }

    protected static Parser createSACParser() throws DOMException {
        return SACParserFactory.createSACParser();
    }

    public void parseCSSStyleSheet(InputSource source) throws DOMException, IOException {
        Parser parser = BaseCSSStyleSheet.createSACParser();
        parser.setDocumentHandler(this.createDocumentHandler());
        parser.parseStyleSheet(source);
    }

    class CSSDocumentHandler
    implements DocumentHandler {
        private CSSRule currentRule = null;
        private boolean ignoreRulesForMedia = false;

        CSSDocumentHandler() {
        }

        public void startDocument(InputSource source) throws CSSException {
            this.currentRule = null;
            this.ignoreRulesForMedia = false;
            log.debug((Object)"Starting StyleSheet processing");
        }

        public void endDocument(InputSource source) throws CSSException {
            log.debug((Object)"Ending StyleSheet processing");
        }

        public void comment(String text) throws CSSException {
        }

        public void ignorableAtRule(String atRule) throws CSSException {
            log.debug((Object)("Ignorable @-rule: " + atRule));
        }

        public void namespaceDeclaration(String prefix, String uri) throws CSSException {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting namespace uri: " + uri));
            }
            BaseCSSStyleSheet.this.setNamespaceURI(uri);
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException, DOMException {
            if (!this.ignoreRulesForMedia || !BaseCSSStyleSheet.this.targetMedia.match(media)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Importing rule from uri: " + uri));
                }
                DOMCSSImportRule imp = new DOMCSSImportRule(BaseCSSStyleSheet.this);
                try {
                    imp.loadStyleSheet(uri, BaseCSSStyleSheet.this.getTitle(), media);
                }
                catch (CSSException e) {
                    throw new CSSException((Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new CSSException((Exception)e);
                }
            } else {
                log.debug((Object)("Ignoring @import from " + uri + ": target media mismatch"));
            }
        }

        public void startMedia(SACMediaList media) throws CSSException {
            if (media.getLength() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Starting @media block for " + media.toString()));
                }
                this.currentRule = new DOMCSSMediaRule(BaseCSSStyleSheet.this);
                int sz = media.getLength();
                int i = 0;
                while (i < sz) {
                    ((CSSMediaRule)this.currentRule).getMedia().appendMedium(media.item(i));
                    ++i;
                }
            } else if (!BaseCSSStyleSheet.this.targetMedia.match(media)) {
                this.ignoreRulesForMedia = true;
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Ignoring @media: target media mismatch. Expected: " + BaseCSSStyleSheet.this.targetMedia.getMediaText()));
            }
        }

        public void endMedia(SACMediaList media) throws CSSException {
            if (this.ignoreRulesForMedia) {
                this.ignoreRulesForMedia = false;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Inserting @media rule " + this.currentRule.getCssText() + " into sheet"));
                }
                BaseCSSStyleSheet.this.addRule(this.currentRule);
            }
            this.currentRule = null;
        }

        public void startPage(String name, String pseudo_page) throws CSSException {
            if (!this.ignoreRulesForMedia) {
                this.currentRule = new DOMCSSPageRule(BaseCSSStyleSheet.this);
            }
        }

        public void endPage(String name, String pseudo_page) throws CSSException {
            if (!this.ignoreRulesForMedia) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Inserting @page rule " + this.currentRule.getCssText() + " into sheet"));
                }
                BaseCSSStyleSheet.this.addRule(this.currentRule);
                this.currentRule = null;
            } else {
                log.debug((Object)"Ignored @page: target media mismatch");
            }
        }

        public void startFontFace() throws CSSException {
            if (!this.ignoreRulesForMedia) {
                this.currentRule = new DOMCSSFontFaceRule(BaseCSSStyleSheet.this);
            } else {
                log.debug((Object)"Ignoring @font-face: target media mismatch");
            }
        }

        public void endFontFace() throws CSSException {
            if (!this.ignoreRulesForMedia) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Inserting @font-face rule " + this.currentRule.getCssText() + " into sheet"));
                }
                BaseCSSStyleSheet.this.addRule(this.currentRule);
                this.currentRule = null;
            }
        }

        public void startSelector(SelectorList selectors) throws CSSException {
            if (!this.ignoreRulesForMedia) {
                if (this.currentRule == null) {
                    this.currentRule = new DOMCSSStyleRule(BaseCSSStyleSheet.this);
                }
                ((CSSStyleDeclarationRule)this.currentRule).setSelectorList(selectors);
                if (log.isDebugEnabled()) {
                    String[] selectorTypes = new String[]{"CONDITIONAL SELECTOR: ", "ANY NODE SELECTOR: ", "ROOT NODE SELECTOR: ", "NEGATIVE SELECTOR: ", "ELEMENT NODE SELECTOR: ", "TEXT NODE SELECTOR: ", "CDATA SECTION NODE SELECTOR: ", "PROCESSING INSTRUCTION NODE SELECTOR: ", "COMMENT NODE SELECTOR: ", "PSEUDO ELEMENT SELECTOR: ", "DESCENDANT SELECTOR: ", "CHILD SELECTOR: ", "DIRECT ADJACENT SELECTOR: "};
                    StringBuilder sb = new StringBuilder(36).append("Found selectors: ").append(selectorTypes[selectors.item(0).getSelectorType()]).append(selectors.item(0));
                    int sz = selectors.getLength();
                    int i = 1;
                    while (i < sz) {
                        sb.append(',').append(' ').append(selectorTypes[selectors.item(0).getSelectorType()]).append(selectors.item(i));
                        ++i;
                    }
                    log.debug((Object)sb.toString());
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Ignoring rule for " + selectors.toString() + ": target media mismatch"));
            }
        }

        public void endSelector(SelectorList selectors) throws CSSException {
            if (!this.ignoreRulesForMedia && this.currentRule instanceof DOMCSSStyleRule) {
                if (((DOMCSSStyleRule)this.currentRule).getStyle().getLength() == 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Discarding empty Style rule for selector " + ((DOMCSSStyleRule)this.currentRule).getSelectorText()));
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Inserting rule " + this.currentRule.getCssText() + " into sheet"));
                    }
                    BaseCSSStyleSheet.this.addRule(this.currentRule);
                }
                this.currentRule = null;
            }
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            if (!this.ignoreRulesForMedia) {
                String importantString = null;
                importantString = important ? "important" : "";
                ((BaseCSSStyleDeclaration)((CSSStyleDeclarationRule)this.currentRule).getStyle()).setProperty(name, value, importantString);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Ignoring property " + name + ": target media mismatch"));
            }
        }
    }
}

