/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.StyleDatabaseAware;
import info.informatica.doc.style.css.StyleDeclarationFactory;
import info.informatica.doc.style.css.dom.BaseCSSStyleDeclaration;
import info.informatica.doc.style.css.dom.BaseCSSStyleSheet;
import info.informatica.doc.style.css.property.CSSNumberValue;
import info.informatica.doc.style.css.property.CSSPercentageValue;
import info.informatica.doc.style.css.property.CSSPropertyException;
import info.informatica.doc.style.css.property.CSSStringValue;
import info.informatica.doc.style.css.property.PropertyDatabase;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public abstract class ComputedCSSStyle
extends BaseCSSStyleDeclaration
implements CSS2ComputedProperties,
StyleDatabaseAware {
    protected ComputedCSSStyle() {
    }

    protected ComputedCSSStyle(BaseCSSStyleDeclaration copiedObject) {
        super(copiedObject);
    }

    public CSSValue getCSSValue(String property) {
        CSSValue value = super.getCSSValue(property);
        boolean inherited = PropertyDatabase.getInstance().isInherited(property);
        CSS2ComputedProperties ancStyle = this;
        while (!(value == null ? !inherited : value.getCssValueType() != 0)) {
            if ((ancStyle = ancStyle.getParentComputedStyle()) == null) break;
            value = ancStyle.getPropertyCSSValue(property);
        }
        if (value != null && value.getCssValueType() == 0) {
            value = null;
        }
        if (value == null) {
            value = this.defaultPropertyValue(property);
        }
        if (value != null && value instanceof StyleDatabaseAware) {
            ((StyleDatabaseAware)((Object)value)).setStyleDatabase(this.getStyleDatabase());
            value = this.applyConstrains(property, value);
        }
        return value;
    }

    private CSSValue applyConstrains(String property, CSSValue value) {
        String strVal;
        CSSValue computedValue = value;
        if ("display".equals(property) && !"none".equals(strVal = ((CSSPrimitiveValue)value).getStringValue())) {
            String position = ((CSSPrimitiveValue)this.getCSSValue("position")).getStringValue();
            if ("absolute".equals(position) || "fixed".equals(position)) {
                computedValue = this.computeConstrainedDisplay(value);
            } else {
                String floatProp = ((CSSPrimitiveValue)this.getCSSValue("float")).getStringValue();
                if (!"none".equals(floatProp)) {
                    computedValue = this.computeConstrainedDisplay(value);
                }
            }
        }
        return computedValue;
    }

    private CSSValue computeConstrainedDisplay(CSSValue value) {
        String display = ((CSSPrimitiveValue)value).getStringValue();
        if ("inline-table".equals(display)) {
            return StyleDeclarationFactory.parseProperty("table");
        }
        if ("inline".equals(display) || "run-in".equals(display) || "table-row-group".equals(display) || "table-column".equals(display) || "table-column-group".equals(display) || "table-header-group".equals(display) || "table-footer-group".equals(display) || "table-row".equals(display) || "table-cell".equals(display) || "table-caption".equals(display) || "inline-block".equals(display)) {
            return StyleDeclarationFactory.parseProperty("block");
        }
        return value;
    }

    public CSSPrimitiveValue getColor() {
        return (CSSPrimitiveValue)this.getCSSValue("color");
    }

    public CSSPrimitiveValue getBackgroundColor() {
        return (CSSPrimitiveValue)this.getCSSValue("background-color");
    }

    public String getBackgroundImage() {
        CSSPrimitiveValue cssVal = (CSSPrimitiveValue)this.getCSSValue("background-image");
        if (cssVal == null) {
            return null;
        }
        String imgUri = cssVal.getCssText();
        if (!imgUri.contains("//")) {
            URL url;
            try {
                url = new URL(this.getBaseURL(), imgUri);
            }
            catch (MalformedURLException e) {
                return imgUri;
            }
            imgUri = url.toExternalForm();
        }
        return imgUri;
    }

    public URL getBaseURL() {
        String baseURL = this.getParentRule().getParentStyleSheet().getHref();
        if (baseURL == null) {
            return ((BaseCSSStyleSheet)this.getParentRule().getParentStyleSheet()).getDocumentBaseURL();
        }
        try {
            return new URL(baseURL);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String getFontFamily() {
        if (this.getStyleDatabase() == null) {
            throw new IllegalStateException("Style database not set");
        }
        CSSStringValue fontFamily = (CSSStringValue)this.getCSSValue("font-family");
        if (fontFamily == null) {
            return this.getStyleDatabase().getDefaultGenericFontFamily();
        }
        String requestedFamily = fontFamily.getStringValue();
        while (!this.getStyleDatabase().isFontFamilyAvailable(requestedFamily)) {
            if ((fontFamily = (CSSStringValue)fontFamily.nextPrimitiveValue()) == null) {
                requestedFamily = this.getStyleDatabase().getDefaultGenericFontFamily();
                break;
            }
            requestedFamily = fontFamily.getStringValue();
        }
        return requestedFamily;
    }

    public String getFontWeight() {
        CSSStringValue fontWeight = (CSSStringValue)this.getCSSValue("font-weight");
        return fontWeight.getStringValue();
    }

    public int getFontSize() {
        CSSPrimitiveValue cssSize = (CSSPrimitiveValue)this.getCSSValue("font-size");
        int sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "medium");
        if (cssSize == null) {
            return sz;
        }
        switch (cssSize.getPrimitiveType()) {
            case 3: {
                float factor = cssSize.getFloatValue((short)3);
                sz = Math.round((float)this.getParentElementFontSize() * factor);
                break;
            }
            case 21: {
                String sizeIdentifier = cssSize.getStringValue();
                if ("larger".equalsIgnoreCase(sizeIdentifier)) {
                    try {
                        sz = this.getLargerFontSize(sz);
                    }
                    catch (CSSPropertyException e) {
                        log.error((Object)"Do not know how to compute larger size");
                        log.error((Object)e);
                    }
                    break;
                }
                if ("smaller".equalsIgnoreCase(sizeIdentifier)) {
                    try {
                        sz = this.getSmallerFontSize(sz);
                    }
                    catch (CSSPropertyException e) {
                        log.error((Object)"Do not know how to compute smaller size");
                        log.error((Object)e);
                    }
                    break;
                }
                try {
                    sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, cssSize.getStringValue());
                }
                catch (DOMException e) {
                    log.error((Object)("Unrecognized CSS identifier for element " + this.getPeerXPath()), (Throwable)e);
                }
                break;
            }
            case 2: {
                float pcnt = cssSize.getFloatValue((short)2);
                sz = Math.round((float)this.getParentElementFontSize() * pcnt / 100.0f);
                break;
            }
            case 9: {
                sz = (int)cssSize.getFloatValue((short)9);
            }
        }
        return sz;
    }

    protected int getLargerFontSize(int defaultSize) throws CSSPropertyException {
        float sz = (float)defaultSize * 1.2f;
        ComputedCSSStyle parentCss = (ComputedCSSStyle)this.getParentComputedStyle();
        if (parentCss != null) {
            parentCss.setStyleDatabase(this.getStyleDatabase());
            CSSPrimitiveValue csssize = (CSSPrimitiveValue)parentCss.getCSSValue("font-size");
            if (csssize != null) {
                switch (csssize.getPrimitiveType()) {
                    case 21: {
                        String baseFontSize = csssize.getStringValue();
                        if (baseFontSize.equals("xx-small")) {
                            sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "x-small");
                            break;
                        }
                        if (baseFontSize.equals("x-small")) {
                            sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "small");
                            break;
                        }
                        if (baseFontSize.equals("small")) {
                            sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "medium");
                            break;
                        }
                        if (baseFontSize.equals("medium")) {
                            sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "large");
                            break;
                        }
                        if (baseFontSize.equals("large")) {
                            sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "x-large");
                            break;
                        }
                        if (baseFontSize.equals("x-large")) {
                            sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "xx-large");
                            break;
                        }
                        if (baseFontSize.equals("xx-large")) {
                            sz = 2.0f * (float)this.getStyleDatabase().getFontSizeFromIdentifier(null, "xx-large") - (float)this.getStyleDatabase().getFontSizeFromIdentifier(null, "x-large");
                            break;
                        }
                        throw new CSSPropertyException("Unknown size identifier " + baseFontSize + " for element " + parentCss.getParentXPath());
                    }
                    default: {
                        sz = (float)parentCss.getFontSize() * 1.2f;
                    }
                }
            }
        }
        return Math.round(sz);
    }

    protected int getSmallerFontSize(int defaultSize) throws CSSPropertyException {
        float sz = (float)defaultSize * 0.82f;
        ComputedCSSStyle parentCss = (ComputedCSSStyle)this.getParentComputedStyle();
        if (parentCss != null) {
            parentCss.setStyleDatabase(this.getStyleDatabase());
            CSSPrimitiveValue csssize = (CSSPrimitiveValue)parentCss.getCSSValue("font-size");
            if (csssize != null) {
                switch (csssize.getPrimitiveType()) {
                    case 21: {
                        String baseFontSize = csssize.getStringValue();
                        if (baseFontSize.equals("xx-small")) {
                            sz = 2.0f * (float)this.getStyleDatabase().getFontSizeFromIdentifier(null, "xx-small") - (float)this.getStyleDatabase().getFontSizeFromIdentifier(null, "x-small");
                            if (!(sz < 0.1f)) break;
                            sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "xx-small");
                            break;
                        }
                        if (baseFontSize.equals("x-small")) {
                            sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "xx-small");
                            break;
                        }
                        if (baseFontSize.equals("small")) {
                            sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "x-small");
                            break;
                        }
                        if (baseFontSize.equals("medium")) {
                            sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "small");
                            break;
                        }
                        if (baseFontSize.equals("large")) {
                            sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "medium");
                            break;
                        }
                        if (baseFontSize.equals("x-large")) {
                            sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "large");
                            break;
                        }
                        if (baseFontSize.equals("xx-large")) {
                            sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "x-large");
                            break;
                        }
                        throw new CSSPropertyException("Unknown size identifier " + baseFontSize + " for element " + parentCss.getParentXPath());
                    }
                    default: {
                        sz = (float)parentCss.getFontSize() * 0.82f;
                    }
                }
            }
        }
        return Math.round(sz);
    }

    protected int getParentElementFontSize() {
        int sz = this.getStyleDatabase().getFontSizeFromIdentifier(null, "medium");
        CSS2ComputedProperties parentCss = this.getParentComputedStyle();
        if (parentCss != null) {
            sz = parentCss.getFontSize();
        }
        return sz;
    }

    public float computeFloatValue(CSSNumberValue cssValue) {
        float value;
        if (cssValue instanceof CSSPercentageValue) {
            value = cssValue.getFloatValue((short)2);
        } else {
            switch (cssValue.getPrimitiveType()) {
                case 3: {
                    value = (float)this.getFontSize() * cssValue.getFloatValue((short)9);
                }
                case 4: {
                    value = (float)this.getStyleDatabase().getExSizeInPt(this.getFontFamily(), this.getFontSize()) * cssValue.getFloatValue((short)9);
                }
            }
            value = cssValue.getFloatValue();
        }
        return value;
    }

    public abstract String getPeerXPath();

    public abstract String getParentXPath();

    public abstract CSS2ComputedProperties getParentComputedStyle();

    public abstract String getText();
}

