/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import info.informatica.doc.style.css.CSSStyleSheetFactory;
import info.informatica.doc.style.css.dom.BaseCSSStyleSheet;
import info.informatica.doc.style.css.dom.CSSRuleArrayList;
import info.informatica.doc.style.css.dom.DOMCSSStyleDeclaration;
import info.informatica.doc.style.css.dom.DOMMediaList;
import info.informatica.doc.style.css.dom.DOMSelectorMatcher;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;

public class DOMCSSStyleSheet
extends BaseCSSStyleSheet
implements Cloneable {
    private Node ownerNode = null;

    public DOMCSSStyleSheet(CSSStyleSheetFactory factory, Node ownerNode, DOMMediaList media, CSSRule ownerRule) {
        super(factory, media, ownerRule);
        this.ownerNode = ownerNode;
    }

    public DOMCSSStyleSheet(CSSStyleSheetFactory factory, Node ownerNode, DOMMediaList media) {
        this(factory, ownerNode, media, null);
    }

    public Node getOwnerNode() {
        return this.ownerNode;
    }

    public CSSStyleDeclaration getComputedStyle(Element elm, String pseudoElt) {
        DOMCSSStyleDeclaration style = null;
        String st = elm.getAttribute("style");
        if (st.length() > 0) {
            style = new DOMCSSStyleDeclaration();
            try {
                style.setCssText(st);
                style.setPeerNode(elm);
            }
            catch (DOMException e) {
                log.error((Object)"Could not parse style", (Throwable)e);
                style = null;
            }
        }
        style = (DOMCSSStyleDeclaration)this.computeStyle(new DOMCSSStyleDeclaration(this), new DOMSelectorMatcher(elm), style, pseudoElt);
        return style;
    }

    public Object clone() throws CloneNotSupportedException {
        DOMCSSStyleSheet myClone = new DOMCSSStyleSheet(this.getStyleSheetFactory(), this.getOwnerNode(), (DOMMediaList)this.getMedia(), this.getOwnerRule());
        myClone.setTitle(this.getTitle());
        myClone.currentInsertionIndex = this.currentInsertionIndex;
        myClone.setDisabled(this.getDisabled());
        myClone.setHref(this.getHref());
        myClone.setNamespaceURI(this.getNamespaceURI());
        myClone.setParentStyleSheet(this.getParentStyleSheet());
        myClone.cssRules = (CSSRuleArrayList)this.cssRules.clone();
        return myClone;
    }
}

