/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.property;

import info.informatica.doc.style.css.StyleDatabase;
import info.informatica.doc.style.css.StyleDatabaseAware;
import info.informatica.doc.style.css.property.AbstractCSSValue;
import info.informatica.doc.style.css.property.CSSIdentifierValue;
import info.informatica.doc.style.css.property.CSSNumberValue;
import info.informatica.doc.style.css.property.CSSPercentageValue;
import info.informatica.doc.style.css.property.CSSStringValue;
import info.informatica.doc.style.css.property.DOMCSSColorValue;
import info.informatica.doc.style.css.property.DOMCSSCounterValue;
import info.informatica.doc.style.css.property.DOMCSSRectValue;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;

public class AbstractCSSPrimitiveValue
extends AbstractCSSValue
implements CSSPrimitiveValue,
StyleDatabaseAware {
    private short primitiveType = 0;
    private LexicalUnit lexicalUnit = null;
    private StyleDatabase styleDb = null;
    private boolean subproperty = false;

    protected AbstractCSSPrimitiveValue(short unitType) {
        super((short)1);
        this.primitiveType = unitType;
    }

    protected AbstractCSSPrimitiveValue() {
        this(0);
    }

    public short getPrimitiveType() {
        return this.primitiveType;
    }

    public void setFloatValue(short unitType, float floatValue) throws DOMException {
        throw new DOMException(15, "Not a Float");
    }

    public float getFloatValue(short unitType) throws DOMException {
        throw new DOMException(15, "Not a Float");
    }

    public void setStringValue(short stringType, String stringValue) throws DOMException {
        throw new DOMException(15, "Not a String");
    }

    public String getStringValue() throws DOMException {
        throw new DOMException(15, "Not a String");
    }

    public Counter getCounterValue() throws DOMException {
        throw new DOMException(15, "Not a Counter");
    }

    public Rect getRectValue() throws DOMException {
        throw new DOMException(15, "Not a Rect");
    }

    public RGBColor getRGBColorValue() throws DOMException {
        throw new DOMException(15, "Not an RGB Color");
    }

    public StyleDatabase getStyleDatabase() {
        return this.styleDb;
    }

    public void setStyleDatabase(StyleDatabase styleDb) {
        this.styleDb = styleDb;
    }

    public void setSubproperty(boolean subp) {
        this.subproperty = subp;
    }

    public boolean isSubproperty() {
        return this.subproperty;
    }

    protected void setCSSUnitType(short cssUnitType) {
        this.primitiveType = cssUnitType;
    }

    void setLexicalUnit(LexicalUnit lunit) {
        this.lexicalUnit = lunit;
        this.setCSSUnitType(AbstractCSSPrimitiveValue.domPrimitiveType(lunit.getLexicalUnitType()));
    }

    LexicalUnit getLexicalUnit() {
        return this.lexicalUnit;
    }

    public CSSPrimitiveValue nextPrimitiveValue() {
        LexicalUnit nextLex = this.getLexicalUnit();
        AbstractCSSPrimitiveValue nextval = null;
        do {
            if ((nextLex = nextLex.getNextLexicalUnit()) != null) continue;
            return null;
        } while ((nextval = (AbstractCSSPrimitiveValue)AbstractCSSPrimitiveValue.createCSSPrimitiveValue(nextLex)) == null);
        nextval.setStyleDatabase(this.getStyleDatabase());
        return nextval;
    }

    static CSSPrimitiveValue createCSSPrimitiveValue(LexicalUnit lunit) {
        short unitType = lunit.getLexicalUnitType();
        AbstractCSSPrimitiveValue primi = null;
        switch (unitType) {
            case 35: {
                primi = new CSSIdentifierValue();
                primi.setLexicalUnit(lunit);
                break;
            }
            case 24: 
            case 36: 
            case 37: {
                primi = new CSSStringValue();
                primi.setLexicalUnit(lunit);
                break;
            }
            case 23: {
                primi = new CSSPercentageValue();
                primi.setLexicalUnit(lunit);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 42: {
                primi = new CSSNumberValue();
                primi.setLexicalUnit(lunit);
                break;
            }
            case 13: {
                primi = new CSSNumberValue();
                primi.setFloatValue(AbstractCSSPrimitiveValue.domPrimitiveType(unitType), lunit.getIntegerValue());
                break;
            }
            case 27: {
                primi = new DOMCSSColorValue();
                primi.setLexicalUnit(lunit);
                break;
            }
            case 38: {
                primi = new DOMCSSRectValue();
                primi.setLexicalUnit(lunit);
                break;
            }
            case 25: {
                primi = new DOMCSSCounterValue();
                primi.setLexicalUnit(lunit);
                break;
            }
            default: {
                primi = null;
            }
        }
        return primi;
    }

    protected static short domPrimitiveType(int sacType) {
        short primiType;
        switch (sacType) {
            case 37: {
                primiType = 22;
                break;
            }
            case 35: {
                primiType = 21;
                break;
            }
            case 36: {
                primiType = 19;
                break;
            }
            case 24: {
                primiType = 20;
                break;
            }
            case 14: {
                primiType = 1;
                break;
            }
            case 19: {
                primiType = 6;
                break;
            }
            case 28: {
                primiType = 11;
                break;
            }
            case 42: {
                primiType = 18;
                break;
            }
            case 15: {
                primiType = 3;
                break;
            }
            case 16: {
                primiType = 4;
                break;
            }
            case 29: {
                primiType = 13;
                break;
            }
            case 33: {
                primiType = 16;
                break;
            }
            case 18: {
                primiType = 8;
                break;
            }
            case 34: {
                primiType = 17;
                break;
            }
            case 20: {
                primiType = 7;
                break;
            }
            case 31: {
                primiType = 14;
                break;
            }
            case 23: {
                primiType = 2;
                break;
            }
            case 22: {
                primiType = 10;
                break;
            }
            case 17: {
                primiType = 5;
                break;
            }
            case 21: {
                primiType = 9;
                break;
            }
            case 30: {
                primiType = 12;
                break;
            }
            case 32: {
                primiType = 15;
                break;
            }
            case 13: {
                primiType = 1;
                break;
            }
            case 27: {
                primiType = 25;
                break;
            }
            case 38: {
                primiType = 24;
                break;
            }
            case 25: {
                primiType = 23;
                break;
            }
            default: {
                primiType = 0;
            }
        }
        return primiType;
    }
}

