/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.visual.box;

import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.visual.CSSBox;
import info.informatica.doc.style.css.visual.ItemMarkerFactory;
import info.informatica.doc.style.css.visual.NonStaticallyPositioned;
import info.informatica.doc.style.css.visual.box.AbstractCSSBox;
import info.informatica.doc.style.css.visual.box.BlockBox;
import info.informatica.doc.style.css.visual.box.DecimalItemMarkerFactory;
import info.informatica.doc.style.css.visual.box.DecimalLeadingZeroItemMarkerFactory;

public class ListItemBox
extends BlockBox {
    private int orderNumber = 0;

    public ListItemBox(CSS2ComputedProperties style) {
        super(style);
    }

    public void setOrderNumber(int index) {
        this.orderNumber = index;
    }

    public int getOrderNumber() {
        return this.orderNumber;
    }

    public CSSBox getGeneratedSibling() {
        String listStyleType = this.getCSSValue("list-style-type").getCssText();
        if (listStyleType.equals("disc") || listStyleType.equals("circle") || listStyleType.equals("square")) {
            return new ListItemMarkerBox(this.getComputedStyle());
        }
        if (!listStyleType.equals("none")) {
            ListItemNumberedMarkerBox markerBox = new ListItemNumberedMarkerBox(this.getComputedStyle());
            ItemMarkerFactory factory = listStyleType.equals("decimal") ? new DecimalItemMarkerFactory() : (listStyleType.equals("decimal-leading-zero") ? new DecimalLeadingZeroItemMarkerFactory() : new DecimalItemMarkerFactory());
            markerBox.setItemMarkerFactory(factory);
            return markerBox;
        }
        return null;
    }

    public class ListItemMarkerBox
    extends AbstractCSSBox
    implements NonStaticallyPositioned {
        private float left;
        private float right;
        private boolean positionInside;

        public ListItemMarkerBox(CSS2ComputedProperties style) {
            super(style);
            this.positionInside = true;
            String stylePosition = this.getCSSValue("list-style-position").getCssText();
            if (stylePosition.equals("outside")) {
                this.positionInside = false;
            }
            this.computeDimension();
        }

        public void computeDimension() {
            if (this.isPositionInside()) {
                this.left = 0.0f;
                this.right = this.getContainerWidth() - ListItemBox.this.getWidth();
            } else {
                this.left = ListItemBox.super.getLeft();
                this.right = ListItemBox.super.getRight();
            }
        }

        public boolean isPositionInside() {
            return this.positionInside;
        }

        public String getMarkerType() {
            return this.getCSSValue("list-style-type").getCssText();
        }

        public float getWidth() {
            return this.getStyleDatabase().floatValueConversion((float)this.getFontSize() * 0.6f, (short)9);
        }

        public float getHeight() {
            return this.getStyleDatabase().floatValueConversion(this.getFontSize(), (short)9);
        }

        public float getLeft() {
            return this.left;
        }

        public float getRight() {
            return this.right;
        }
    }

    public class ListItemNumberedMarkerBox
    extends ListItemMarkerBox {
        private ItemMarkerFactory factory;

        public ListItemNumberedMarkerBox(CSS2ComputedProperties style) {
            super(style);
        }

        public void setItemMarkerFactory(ItemMarkerFactory factory) {
            this.factory = factory;
        }

        public String itemSymbol() {
            return this.factory.marker(ListItemBox.this.getOrderNumber());
        }
    }
}

