/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.visual.box;

import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.visual.CSSTableCellBox;
import info.informatica.doc.style.css.visual.CSSTableRowBox;
import info.informatica.doc.style.css.visual.box.AbstractCSSBox;
import info.informatica.doc.style.css.visual.box.TableCellBox;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableRowBox
extends AbstractCSSBox
implements CSSTableRowBox {
    private LinkedList<TableCellBox> columns = new LinkedList();
    private int columnCount = 0;

    public TableRowBox(CSS2ComputedProperties style) {
        super(style);
    }

    public void add(TableCellBox cell) {
        int colspan = cell.columnSpan();
        if (colspan < 1) {
            this.getErrorHandler().error("colspan less than 1");
            colspan = 1;
        }
        this.columnCount += colspan;
        cell.setRowIndex(this.columns.size());
        this.columns.add(cell);
    }

    public Iterator<TableCellBox> iterator() {
        return this.columns.iterator();
    }

    public CSSTableCellBox[] getCells() {
        return this.columns.toArray(new CSSTableCellBox[0]);
    }

    public TableCellBox getLast() {
        return this.columns.getLast();
    }

    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    protected float getWidth() {
        return this.getContentWidth();
    }

    @Override
    public float getContentWidth() {
        float width = 0.0f;
        for (TableCellBox cell : this.columns) {
            width += cell.getWidth();
        }
        return width;
    }

    @Override
    protected float getHeight() {
        return this.computeAutoHeight(this.getContainerWidth());
    }

    @Override
    public float computeAutoHeight(float containerWidth) {
        float height = 0.0f;
        for (TableCellBox cell : this.columns) {
            float cellHeight = cell.computeAutoHeight(containerWidth);
            if (!(cellHeight > height)) continue;
            height = cellHeight;
        }
        return height;
    }
}

