/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.agent;


/**
 * Listener for the downloading of document content.
 * 
 * @author Carlos Amengual
 *
 */
public interface DownloadListener<C> {

	/**
	 * Notifies the download of content.
	 * 
	 * @param content the content, in a native object.
	 */
	public void doContentDownloaded(C content);

	/**
	 * Notifies a failed download.
	 *
	 */
	public void doFailedDownload();

	/**
	 * Gets the content, put into a native object.
	 * 
	 * @return the downloaded content.
	 */
	public C getNativeContent();

}