/*

 Copyright (c) 2005-2011, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.dom4j;

import java.net.MalformedURLException;
import java.net.URL;

import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMAttribute;

/**
 * Href attribute of Base element.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
class BaseHrefAttribute extends DOMAttribute {

	private static final long serialVersionUID = 3L;

	BaseHrefAttribute(QName qname) {
		super(qname);
	}

	BaseHrefAttribute(QName qname, String value) {
		super(qname, value);
	}

	BaseHrefAttribute(Element parent, QName qname, String value) {
		super(parent, qname, value);
	}

	@Override
	public void setValue(String value) {
		super.setValue(value);
		if (value != null) {
			URL base;
			try {
				base = new URL(value);
			} catch (MalformedURLException e) {
				XHTMLDocument doc = (XHTMLDocument) getDocument();
				if(doc != null) {
					doc.setBaseURL(null);
				}
				return;
			}
			XHTMLDocument doc = (XHTMLDocument) getDocument();
			if(doc != null) {
				doc.setBaseURL(base);
			}
		} else {
			XHTMLDocument doc = (XHTMLDocument) getDocument();
			if(doc != null) {
				doc.setBaseURL(null);
			}
		}
	}

}
