/*

 Copyright (c) 2005-2011, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.dom4j;

import info.informatica.doc.style.css.property.AttributeToStyle;

import org.dom4j.QName;

/**
 * Cached table row element.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 * 
 */
public class CachedTableRowElement extends CachedCSSStylableElement {

	private static final long serialVersionUID = 1L;

	protected CachedTableRowElement(String name) {
		super(name);
	}

	protected CachedTableRowElement(QName qname) {
		super(qname);
	}

    CachedTableRowElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

	protected String inlineStyle() {
		StringBuilder buf;
		String styleAttr = attributeValue("style");
		if(styleAttr != null) {
			buf = new StringBuilder(16 + styleAttr.length());
			buf.append(styleAttr);
			if(styleAttr.charAt(styleAttr.length() - 1) != ';') {
				buf.append(';');
			}
		} else {
			buf = new StringBuilder(16);
		}
		AttributeToStyle.bgcolor(attributeValue("bgcolor"), buf);
		return buf.toString();
	}

}
